/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.api.classloading;

import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.api.classloading.SecurityActions;
import java.lang.reflect.Constructor;
import java.net.URL;

public class ClassLoaderFactory {
    public static final int TYPE_PARENT_FIRST = 0;
    public static final int TYPE_PARENT_LAST = 1;
    public static final int TYPE_EXPORT = 2;
    private static final String CLASSLOADER_PARENT_FIRST = "com.github.fungal.impl.classloader.ParentFirstClassLoader";
    private static final String CLASSLOADER_PARENT_LAST = "com.github.fungal.impl.classloader.ParentLastClassLoader";
    private static final String CLASSLOADER_EXPORT = "com.github.fungal.impl.classloader.ExportClassLoader";

    private ClassLoaderFactory() {
    }

    public static synchronized KernelClassLoader create(int type, URL[] urls, ClassLoader parent) throws IllegalArgumentException, IllegalStateException {
        if (type == 0) {
            try {
                Class<?> clz = Class.forName(CLASSLOADER_PARENT_FIRST, true, SecurityActions.getClassLoader(ClassLoaderFactory.class));
                Constructor<?> constructor = SecurityActions.getDeclaredConstructor(clz, URL[].class, ClassLoader.class);
                SecurityActions.setAccessible(constructor);
                return (KernelClassLoader)constructor.newInstance(urls, parent);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to create parent first classloader", t);
            }
        }
        if (type == 1) {
            try {
                Class<?> clz = Class.forName(CLASSLOADER_PARENT_LAST, true, SecurityActions.getClassLoader(ClassLoaderFactory.class));
                Constructor<?> constructor = SecurityActions.getDeclaredConstructor(clz, URL[].class, ClassLoader.class);
                SecurityActions.setAccessible(constructor);
                return (KernelClassLoader)constructor.newInstance(urls, parent);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to create parent last classloader", t);
            }
        }
        if (type == 2) {
            try {
                Class<?> clz = Class.forName(CLASSLOADER_EXPORT, true, SecurityActions.getClassLoader(ClassLoaderFactory.class));
                Constructor<?> constructor = SecurityActions.getDeclaredConstructor(clz, URL[].class, ClassLoader.class);
                SecurityActions.setAccessible(constructor);
                return (KernelClassLoader)constructor.newInstance(urls, parent);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to create export classloader", t);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }
}

