/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.remote;

import com.github.fungal.api.remote.Command;
import com.github.fungal.impl.remote.CommunicationServer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Communication
implements Runnable {
    private Logger log = Logger.getLogger(Communication.class.getName());
    private boolean trace = this.log.isLoggable(Level.FINEST);
    private CommunicationServer cs;
    private Socket socket;

    public Communication(CommunicationServer cs, Socket socket) {
        this.cs = cs;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ObjectInputStream ois = new ObjectInputStream(this.socket.getInputStream());
            String commandName = ois.readUTF();
            int length = ois.readInt();
            Command command = this.cs.getCommand(commandName);
            Serializable result = null;
            if (command != null) {
                Class[] parameterTypes = command.getParameterTypes();
                Serializable[] arguments = null;
                int i = 0;
                if (length > 0) {
                    arguments = new Serializable[length];
                }
                if (parameterTypes != null) {
                    for (i = 0; i < parameterTypes.length; ++i) {
                        arguments[i] = (Serializable)ois.readObject();
                    }
                }
                if (i < length) {
                    for (int j = i; j < length; ++j) {
                        arguments[j] = (Serializable)ois.readObject();
                    }
                }
                result = command.invoke(arguments);
            } else {
                result = new IOException("Unknown command: " + commandName);
            }
            ObjectOutputStream oos = new ObjectOutputStream(this.socket.getOutputStream());
            oos.writeObject(result);
            oos.flush();
        }
        catch (Throwable t) {
            try {
                StringWriter sw = new StringWriter();
                sw.write(t.getMessage());
                sw.write(10);
                t.printStackTrace(new PrintWriter(sw));
                ObjectOutputStream oos = new ObjectOutputStream(this.socket.getOutputStream());
                oos.writeObject(sw.toString());
                oos.flush();
            }
            catch (IOException ioe) {
                this.log.log(Level.SEVERE, ioe.getMessage(), ioe);
            }
        }
        finally {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException ignore) {}
        }
    }
}

