/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.RMIContext;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.event.Event;
import org.jboss.arquillian.extension.byteman.api.ExecType;
import org.jboss.arquillian.extension.byteman.impl.client.AddressProvider;
import org.jboss.arquillian.extension.byteman.impl.common.AbstractRuleInstaller;
import org.jboss.arquillian.extension.byteman.impl.common.BytemanConfiguration;
import org.jboss.arquillian.extension.byteman.impl.common.ExecContext;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;

public class RuleInstaller
extends AbstractRuleInstaller {
    @Inject
    private Instance<Deployment> deploymentInstance;
    @Inject
    private Instance<Container> containerInstance;
    @Inject
    private Instance<ArquillianDescriptor> descriptorInst;
    @Inject
    private Instance<ProtocolMetaData> protocolMetaDataInstance;

    protected String readAddress(Event event) {
        String address = AddressProvider.provideAddress(event);
        if (address != null) {
            return address;
        }
        ProtocolMetaData pmd = (ProtocolMetaData)this.protocolMetaDataInstance.get();
        if (pmd == null) {
            return null;
        }
        address = AddressProvider.extractAddress(event, pmd);
        if (address != null) {
            return address;
        }
        HTTPContext httpContext = (HTTPContext)pmd.getContext(HTTPContext.class);
        if (httpContext != null) {
            return httpContext.getHost();
        }
        RMIContext rmiContext = (RMIContext)pmd.getContext(RMIContext.class);
        if (rmiContext != null) {
            return rmiContext.getIp();
        }
        JMXContext jmxContext = (JMXContext)pmd.getContext(JMXContext.class);
        if (jmxContext != null) {
            try {
                Field hostField = JMXContext.class.getDeclaredField("host");
                hostField.setAccessible(true);
                return (String)hostField.get(jmxContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected List<ExecContext> getExecContexts(Event event) {
        BytemanConfiguration config = BytemanConfiguration.from((ArquillianDescriptor)this.descriptorInst.get());
        ArrayList<ExecContext> list = new ArrayList<ExecContext>();
        if (config.clientAgentPort() == config.containerAgentPort()) {
            ExecContext context = new ExecContext(config.clientAgentPort(), EnumSet.complementOf(EnumSet.of(ExecType.CONTAINER)), config);
            list.add(context);
        } else {
            list.add(new ExecContext(config.clientAgentPort(), EnumSet.complementOf(EnumSet.of(ExecType.CONTAINER, ExecType.CLIENT_CONTAINER)), config));
            String address = this.readAddress(event);
            ExecContext remote = address != null ? new ExecContext(address, config.containerAgentPort(), EnumSet.of(ExecType.CLIENT_CONTAINER), config) : new ExecContext(config.containerAgentPort(), EnumSet.of(ExecType.CLIENT_CONTAINER), config);
            list.add(remote);
        }
        return list;
    }

    @Override
    protected boolean shouldRun(TestEvent event) {
        return RuleInstaller.shouldRun((Deployment)this.deploymentInstance.get(), (Container)this.containerInstance.get(), event);
    }

    private static boolean shouldRun(Deployment deployment, Container container, TestEvent event) {
        if (RuleInstaller.isRunAsClient(deployment, event.getTestClass().getJavaClass(), event.getTestMethod())) {
            return true;
        }
        return RuleInstaller.isLocalContainer(container);
    }

    private static boolean isRunAsClient(Deployment deployment, Class<?> testClass, Method testMethod) {
        boolean runAsClient = true;
        if (deployment != null) {
            runAsClient = !deployment.getDescription().testable();
            boolean bl = runAsClient = !deployment.isDeployed() || runAsClient;
            if (testMethod.isAnnotationPresent(RunAsClient.class)) {
                runAsClient = true;
            } else if (testClass.isAnnotationPresent(RunAsClient.class)) {
                runAsClient = true;
            }
        }
        return runAsClient;
    }

    private static boolean isLocalContainer(Container container) {
        if (container == null || container.getDeployableContainer() == null || container.getDeployableContainer().getDefaultProtocol() == null) {
            return false;
        }
        return "Local".equals(container.getDeployableContainer().getDefaultProtocol().getName());
    }
}

