/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.UnaryOperExpression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class NotExpression
extends UnaryOperExpression {
    public NotExpression(Rule rule, ParseNode token, Expression operand) {
        super(rule, 4112, Type.BOOLEAN, token, operand);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.type = this.getOperand(0).typeCheck(Type.Z);
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("NotExpression.typeCheck() : invalid result type : " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Boolean result = (Boolean)this.getOperand(0).interpret(helper);
        return result == false;
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Expression oper = this.getOperand(0);
        Type operType = oper.getType();
        int currentStack = compileContext.getStackCount();
        int expected = 1;
        oper.compile(mv, compileContext);
        this.compileTypeConversion(operType, this.type, mv, compileContext);
        mv.visitInsn(116);
        mv.visitInsn(4);
        mv.visitInsn(96);
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("NotExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack + expected);
        }
    }
}

