/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.api.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress(File directory, File target) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target is null");
        }
        if (target.exists()) {
            this.delete(target);
        }
        Manifest manifest = null;
        File manifestFile = new File(directory, "META-INF/MANIFEST.MF");
        if (manifestFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(manifestFile);
                manifest = new Manifest(fis);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ignore) {}
            }
        }
        manifest = new Manifest();
        ZipOutputStream jos = null;
        try {
            FileOutputStream fos = new FileOutputStream(target);
            jos = new JarOutputStream((OutputStream)fos, manifest);
            byte[] buffer = new byte[4096];
            List<File> entries = this.findEntries(directory);
            if (entries != null) {
                entries.remove(new File("META-INF/MANIFEST.MF"));
                for (File file : entries) {
                    File f = new File(directory, file.getPath());
                    JarEntry entry = new JarEntry(file.getPath());
                    ((JarOutputStream)jos).putNextEntry(entry);
                    FileInputStream in = null;
                    try {
                        int bytesRead;
                        in = new FileInputStream(f);
                        while ((bytesRead = in.read(buffer)) != -1) {
                            jos.write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            jos.flush();
        }
        finally {
            try {
                if (jos != null) {
                    jos.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File extract(File file, File directory) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        File target = new File(directory, file.getName());
        if (target.exists()) {
            this.delete(target);
        }
        if (!target.mkdirs()) {
            throw new IOException("Could not create " + target);
        }
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            File copy = new File(target, je.getName());
            if (!je.isDirectory()) {
                BufferedInputStream in = null;
                OutputStream out = null;
                if (copy.getParentFile() != null && !copy.getParentFile().exists() && !copy.getParentFile().mkdirs()) {
                    throw new IOException("Could not create " + copy.getParentFile());
                }
                try {
                    int nBytes;
                    in = new BufferedInputStream(jar.getInputStream(je));
                    out = new BufferedOutputStream(new FileOutputStream(copy));
                    byte[] buffer = new byte[4096];
                    while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                        out.write(buffer, 0, nBytes);
                    }
                    out.flush();
                    continue;
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ignore) {}
                    try {
                        if (in == null) continue;
                        ((InputStream)in).close();
                    }
                    catch (IOException ignore) {}
                    continue;
                }
            }
            if (!copy.exists()) {
                if (copy.mkdirs()) continue;
                throw new IOException("Could not create " + copy);
            }
            if (copy.isDirectory()) continue;
            throw new IOException(copy + " isn't a directory");
        }
        jar.close();
        return target;
    }

    public void copy(File src, File dest) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("Src is null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Dest is null");
        }
        if (!src.exists()) {
            throw new IOException("Source doesn't exist: " + src.getAbsolutePath());
        }
        if (!src.canRead()) {
            throw new IOException("Source can't be read: " + src.getAbsolutePath());
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("Could not create directory: " + dest.getAbsolutePath());
            }
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                File srcFile = new File(src, list[i]);
                File destFile = new File(dest, list[i]);
                this.copy(srcFile, destFile);
            }
        } else {
            InputStream in = null;
            OutputStream out = null;
            byte[] buffer = new byte[8192];
            try {
                int bytesRead;
                in = new BufferedInputStream(new FileInputStream(src), 8192);
                out = new BufferedOutputStream(new FileOutputStream(dest), 8192);
                while ((bytesRead = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, bytesRead);
                }
                out.flush();
            }
            catch (IOException e) {
                IOException wrapper = new IOException("Unable to copy file: " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
                wrapper.initCause(e);
                wrapper.setStackTrace(e.getStackTrace());
                throw wrapper;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    public void delete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.delete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }

    private List<File> findEntries(File root) {
        return this.getListing(root, root);
    }

    private List<File> getListing(File root, File directory) {
        ArrayList<File> result = null;
        File[] filesAndDirs = directory.listFiles();
        if (filesAndDirs != null) {
            result = new ArrayList<File>(filesAndDirs.length);
            for (File file : filesAndDirs) {
                if (file.isDirectory()) {
                    List<File> deeperList = this.getListing(root, file);
                    result.addAll(deeperList);
                    continue;
                }
                String fileName = file.getPath().substring(root.getPath().length() + 1);
                result.add(new File(fileName));
            }
        }
        return result;
    }
}

