/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.remote;

import com.github.fungal.api.remote.Command;
import com.github.fungal.impl.KernelImpl;
import com.github.fungal.impl.remote.Communication;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommunicationServer
implements Runnable {
    private Logger log = Logger.getLogger(CommunicationServer.class.getName());
    private boolean trace = this.log.isLoggable(Level.FINEST);
    private KernelImpl kernel;
    private String bindAddress;
    private int bindPort;
    private AtomicBoolean running;
    private ServerSocket ss;
    private ConcurrentMap<String, Command> commands;

    public CommunicationServer(KernelImpl kernel, String bindAddress, int bindPort) throws IOException {
        if (bindAddress == null) {
            bindAddress = "localhost";
        }
        this.kernel = kernel;
        this.bindAddress = bindAddress;
        this.bindPort = bindPort;
        this.running = new AtomicBoolean(false);
        this.ss = null;
        this.commands = new ConcurrentHashMap<String, Command>();
    }

    public void registerCommand(Command command) {
        if (command == null) {
            throw new IllegalArgumentException("Command is null");
        }
        if (!this.commands.containsKey(command.getName())) {
            this.commands.put(command.getName(), command);
        }
    }

    public void unregisterCommand(Command command) {
        if (command == null) {
            throw new IllegalArgumentException("Command is null");
        }
        if (this.commands.containsKey(command.getName())) {
            this.commands.remove(command.getName());
        }
    }

    public Set<String> getCommandNames() {
        return this.commands.keySet();
    }

    public Command getCommand(String name) {
        return (Command)this.commands.get(name);
    }

    public void start() throws Throwable {
        if (!this.running.get()) {
            InetSocketAddress address = new InetSocketAddress(this.bindAddress, this.bindPort);
            this.ss = new ServerSocket();
            this.ss.bind(address);
            this.running.set(true);
        }
    }

    public void stop() throws Throwable {
        block3: {
            this.running.set(false);
            if (this.ss != null) {
                try {
                    this.ss.close();
                }
                catch (IOException ioe) {
                    if (!this.log.isLoggable(Level.FINE)) break block3;
                    this.log.fine(ioe.getMessage());
                }
            }
        }
    }

    @Override
    public void run() {
        while (this.running.get()) {
            try {
                Socket socket = this.ss.accept();
                Communication r = new Communication(this, socket);
                this.kernel.getExecutorService().submit(r);
            }
            catch (IOException ioe) {
                if (!this.log.isLoggable(Level.FINE)) continue;
                this.log.fine(ioe.getMessage());
            }
        }
    }
}

