/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile;

import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.JavaClass;

public class ClassDescriptor
implements Comparable<ClassDescriptor>,
Serializable {
    private static final long serialVersionUID = 1L;
    @SlashedClassName
    private final String className;
    private static final Pattern ANONYMOUS_CLASS_NAME = Pattern.compile(".*\\$[0-9]*$");
    public static final ClassDescriptor[] EMPTY_ARRAY = new ClassDescriptor[0];

    protected ClassDescriptor(@SlashedClassName String className) {
        if (className.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Class name " + className + " not in VM format");
        }
        if (!ClassName.isValidClassName(className)) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        this.className = className;
    }

    @SlashedClassName
    public final String getClassName() {
        return this.className;
    }

    @Override
    public int compareTo(ClassDescriptor o) {
        return this.className.compareTo(o.className);
    }

    public boolean matches(Class<?> c) {
        return this.getDottedClassName().equals(c.getName());
    }

    public String toResourceName() {
        return this.className + ".class";
    }

    @DottedClassName
    public String toDottedClassName() {
        return ClassName.toDottedClassName(this.className);
    }

    @DottedClassName
    public String getDottedClassName() {
        return ClassName.toDottedClassName(this.className);
    }

    public XClass getXClass() throws CheckedAnalysisException {
        return Global.getAnalysisCache().getClassAnalysis(XClass.class, this);
    }

    @DottedClassName
    public String getPackageName() {
        return ClassName.extractPackageName(ClassName.toDottedClassName(this.className));
    }

    public String getSimpleName() {
        return ClassName.extractSimpleName(ClassName.toDottedClassName(this.className));
    }

    public String getSignature() {
        if (this.isArray()) {
            return this.className;
        }
        return "L" + this.className + ";";
    }

    public boolean isArray() {
        return this.className.charAt(0) == '[';
    }

    @Deprecated
    public static ClassDescriptor fromResourceName(String resourceName) {
        return DescriptorFactory.createClassDescriptorFromResourceName(resourceName);
    }

    @Deprecated
    @CheckForNull
    public static ClassDescriptor fromFieldSignature(String signature) {
        return DescriptorFactory.createClassDescriptorFromFieldSignature(signature);
    }

    @Deprecated
    public static boolean isClassResource(String resourceName) {
        return DescriptorFactory.isClassResource(resourceName);
    }

    @Deprecated
    public static ClassDescriptor createClassDescriptorFromSignature(String signature) {
        return DescriptorFactory.createClassDescriptorFromSignature(signature);
    }

    @Deprecated
    public static ClassDescriptor createClassDescriptor(@SlashedClassName String className) {
        return DescriptorFactory.createClassDescriptor(className);
    }

    @Deprecated
    public static ClassDescriptor[] createClassDescriptor(String[] classNames) {
        return DescriptorFactory.createClassDescriptor(classNames);
    }

    @Deprecated
    public static ClassDescriptor createClassDescriptorFromDottedClassName(String dottedClassName) {
        return DescriptorFactory.createClassDescriptorFromDottedClassName(dottedClassName);
    }

    @Deprecated
    public static ClassDescriptor createClassDescriptor(JavaClass c) {
        return DescriptorFactory.createClassDescriptor(c);
    }

    public String toString() {
        return this.className;
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClassDescriptor)) {
            return false;
        }
        return this.getClassName().equals(((ClassDescriptor)obj).getClassName());
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public static void throwClassNotFoundException(ClassDescriptor classDescriptor) throws ClassNotFoundException {
        throw new ClassNotFoundException("Class " + classDescriptor.toDottedClassName() + " cannot be resolved");
    }

    public boolean isAnonymousClass() {
        return ANONYMOUS_CLASS_NAME.matcher(this.className).matches();
    }
}

