/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.SortedSet;
import org.jboss.tattletale.reporting.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dump {
    protected static final String NEW_LINE = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateCSS(String outputDir) {
        byte[] buffer = new byte[8192];
        InputStream is = null;
        OutputStream os = null;
        try {
            int bytesRead;
            is = Dump.class.getClassLoader().getResourceAsStream("style.css");
            os = new FileOutputStream(outputDir + "style.css");
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.flush();
        }
        catch (Exception e) {
            System.err.println("GenerateCSS: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public static void generateIndex(SortedSet<Report> dependenciesReports, SortedSet<Report> generalReports, SortedSet<Report> archiveReports, String outputDir) {
        try {
            FileWriter fw = new FileWriter(outputDir + "index.html");
            BufferedWriter bw = new BufferedWriter(fw, 8192);
            bw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">" + NEW_LINE);
            bw.write("<html>" + NEW_LINE);
            bw.write("<head>" + NEW_LINE);
            bw.write("  <title>JBoss Tattletale 1.1.1.Final: Index</title>" + NEW_LINE);
            bw.write("  <meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">" + NEW_LINE);
            bw.write("  <link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\">" + NEW_LINE);
            bw.write("</head>" + NEW_LINE);
            bw.write("<body>" + NEW_LINE);
            bw.write(NEW_LINE);
            bw.write("<h1>JBoss Tattletale 1.1.1.Final</h1>" + NEW_LINE);
            if (dependenciesReports != null && dependenciesReports.size() > 0) {
                bw.write("<h2>Dependencies</h2>" + NEW_LINE);
                bw.write("<ul>" + NEW_LINE);
                for (Report r : dependenciesReports) {
                    bw.write("<li>");
                    bw.write("<a href=\"" + r.getDirectory() + "/index.html\">" + r.getName() + "</a> (");
                    bw.write("<span");
                    if (r.getStatus() == 0) {
                        bw.write(" style=\"color: green;\"");
                    } else if (r.getStatus() == 1) {
                        bw.write(" style=\"color: yellow;\"");
                    } else if (r.getStatus() == 2) {
                        bw.write(" style=\"color: red;\"");
                    }
                    bw.write(">");
                    if (r.getSeverity() == 0) {
                        bw.write("INFO");
                    } else if (r.getSeverity() == 1) {
                        bw.write("WARNING");
                    } else if (r.getSeverity() == 2) {
                        bw.write("ERROR");
                    }
                    bw.write("</span>");
                    bw.write(")</li>" + NEW_LINE);
                }
                bw.write("</ul>" + NEW_LINE);
            }
            if (generalReports != null && generalReports.size() > 0) {
                bw.write("<h2>Reports</h2>" + NEW_LINE);
                bw.write("<ul>" + NEW_LINE);
                for (Report r : generalReports) {
                    bw.write("<li>");
                    bw.write("<a href=\"" + r.getDirectory() + "/index.html\">" + r.getName() + "</a> (");
                    bw.write("<span");
                    if (r.getStatus() == 0) {
                        bw.write(" style=\"color: green;\"");
                    } else if (r.getStatus() == 1) {
                        bw.write(" style=\"color: yellow;\"");
                    } else if (r.getStatus() == 2) {
                        bw.write(" style=\"color: red;\"");
                    }
                    bw.write(">");
                    if (r.getSeverity() == 0) {
                        bw.write("INFO");
                    } else if (r.getSeverity() == 1) {
                        bw.write("WARNING");
                    } else if (r.getSeverity() == 2) {
                        bw.write("ERROR");
                    }
                    bw.write("</span>");
                    bw.write(")</li>" + NEW_LINE);
                }
                bw.write("</ul>" + NEW_LINE);
            }
            if (archiveReports != null && archiveReports.size() > 0) {
                bw.write("<h2>Archives</h2>" + NEW_LINE);
                bw.write("<ul>" + NEW_LINE);
                for (Report r : archiveReports) {
                    bw.write("<li>");
                    bw.write("<a href=\"" + r.getDirectory() + "/" + r.getName() + ".html\">" + r.getName() + "</a> (");
                    bw.write("<span");
                    if (r.getStatus() == 0) {
                        bw.write(" style=\"color: green;\"");
                    } else if (r.getStatus() == 1) {
                        bw.write(" style=\"color: yellow;\"");
                    } else if (r.getStatus() == 2) {
                        bw.write(" style=\"color: red;\"");
                    }
                    bw.write(">");
                    if (r.getSeverity() == 0) {
                        bw.write("INFO");
                    } else if (r.getSeverity() == 1) {
                        bw.write("WARNING");
                    } else if (r.getSeverity() == 2) {
                        bw.write("ERROR");
                    }
                    bw.write("</span>");
                    bw.write(")</li>" + NEW_LINE);
                }
                bw.write("</ul>" + NEW_LINE);
            }
            bw.write(NEW_LINE);
            bw.write("<p>" + NEW_LINE);
            bw.write("<hr>" + NEW_LINE);
            bw.write("Generated by: <a href=\"http://www.jboss.org/projects/tattletale\">JBoss Tattletale 1.1.1.Final</a>" + NEW_LINE);
            bw.write(NEW_LINE);
            bw.write("</body>" + NEW_LINE);
            bw.write("</html>" + NEW_LINE);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.err.println("GenerateIndex: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

