/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile;

import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.MethodInfo;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.MapCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ObjectType;

public class DescriptorFactory {
    private static ThreadLocal<DescriptorFactory> instanceThreadLocal = new ThreadLocal<DescriptorFactory>(){

        @Override
        protected DescriptorFactory initialValue() {
            return new DescriptorFactory();
        }
    };
    private final Map<String, ClassDescriptor> classDescriptorMap;
    private final Map<String, ClassDescriptor> dottedClassDescriptorMap;
    private final Map<MethodDescriptor, MethodDescriptor> methodDescriptorMap;
    private final Map<FieldDescriptor, FieldDescriptor> fieldDescriptorMap;
    private final MapCache<String, String> stringCache = new MapCache(10000);

    private DescriptorFactory() {
        this.classDescriptorMap = new HashMap<String, ClassDescriptor>();
        this.dottedClassDescriptorMap = new HashMap<String, ClassDescriptor>();
        this.methodDescriptorMap = new HashMap<MethodDescriptor, MethodDescriptor>();
        this.fieldDescriptorMap = new HashMap<FieldDescriptor, FieldDescriptor>();
    }

    public static String canonicalizeString(@CheckForNull String s) {
        if (s == null) {
            return s;
        }
        DescriptorFactory df = instanceThreadLocal.get();
        String cached = (String)df.stringCache.get(s);
        if (cached != null) {
            return cached;
        }
        df.stringCache.put(s, s);
        return s;
    }

    public static DescriptorFactory instance() {
        return instanceThreadLocal.get();
    }

    public static void clearInstance() {
        instanceThreadLocal.remove();
    }

    public Collection<ClassDescriptor> getAllClassDescriptors() {
        return this.classDescriptorMap.values();
    }

    public void purge(Collection<ClassDescriptor> unusable) {
        for (ClassDescriptor c : unusable) {
            this.classDescriptorMap.remove(c.getClassName());
            this.dottedClassDescriptorMap.remove(c.getClassName().replace('/', '.'));
        }
    }

    @Nonnull
    public ClassDescriptor getClassDescriptor(Class<?> actualClass) {
        return this.getClassDescriptorForDottedClassName(actualClass.getName());
    }

    @Nonnull
    public ClassDescriptor getClassDescriptor(@SlashedClassName String className) {
        assert (className.indexOf(46) == -1);
        ClassDescriptor classDescriptor = this.classDescriptorMap.get(className = DescriptorFactory.canonicalizeString(className));
        if (classDescriptor == null) {
            classDescriptor = new ClassDescriptor(className);
            this.classDescriptorMap.put(className, classDescriptor);
        }
        return classDescriptor;
    }

    public ClassDescriptor getClassDescriptorForDottedClassName(@DottedClassName String dottedClassName) {
        assert (dottedClassName != null);
        ClassDescriptor classDescriptor = this.dottedClassDescriptorMap.get(dottedClassName);
        if (classDescriptor == null) {
            classDescriptor = this.getClassDescriptor(dottedClassName.replace('.', '/'));
            this.dottedClassDescriptorMap.put(dottedClassName, classDescriptor);
        }
        return classDescriptor;
    }

    public MethodDescriptor getMethodDescriptor(JavaClass jClass, Method method) {
        return this.getMethodDescriptor(ClassName.toSlashedClassName(jClass.getClassName()), method.getName(), method.getSignature(), method.isStatic());
    }

    public MethodDescriptor getMethodDescriptor(@SlashedClassName String className, String name, String signature, boolean isStatic) {
        if (className == null) {
            throw new NullPointerException("className must be nonnull");
        }
        MethodDescriptor methodDescriptor = new MethodDescriptor(className, name, signature, isStatic);
        MethodDescriptor existing = this.methodDescriptorMap.get(methodDescriptor);
        if (existing == null) {
            this.methodDescriptorMap.put(methodDescriptor, methodDescriptor);
            existing = methodDescriptor;
        }
        return existing;
    }

    public void profile() {
        int total = 0;
        int keys = 0;
        int values = 0;
        boolean bad = false;
        for (Map.Entry<MethodDescriptor, MethodDescriptor> e : this.methodDescriptorMap.entrySet()) {
            ++total;
            if (e.getKey() instanceof MethodInfo) {
                ++keys;
            }
            if (!(e.getValue() instanceof MethodInfo)) continue;
            ++values;
        }
        System.out.printf("Descriptor factory: %d/%d/%d%n", keys, values, total);
    }

    public void canonicalize(MethodDescriptor m) {
        MethodDescriptor existing = this.methodDescriptorMap.get(m);
        if (m != existing) {
            this.methodDescriptorMap.put(m, m);
        }
    }

    public void canonicalize(FieldDescriptor m) {
        FieldDescriptor existing = this.fieldDescriptorMap.get(m);
        if (m != existing) {
            this.fieldDescriptorMap.put(m, m);
        }
    }

    public MethodDescriptor getMethodDescriptor(MethodAnnotation ma) {
        return this.getMethodDescriptor(ClassName.toSlashedClassName(ma.getClassName()), ma.getMethodName(), ma.getMethodSignature(), ma.isStatic());
    }

    public FieldDescriptor getFieldDescriptor(@SlashedClassName String className, String name, String signature, boolean isStatic) {
        FieldDescriptor fieldDescriptor = new FieldDescriptor(className, name, signature, isStatic);
        FieldDescriptor existing = this.fieldDescriptorMap.get(fieldDescriptor);
        if (existing == null) {
            this.fieldDescriptorMap.put(fieldDescriptor, fieldDescriptor);
            existing = fieldDescriptor;
        }
        return existing;
    }

    public FieldDescriptor getFieldDescriptor(@SlashedClassName String className, Field ma) {
        return this.getFieldDescriptor(className, ma.getName(), ma.getSignature(), ma.isStatic());
    }

    public FieldDescriptor getFieldDescriptor(FieldAnnotation ma) {
        return this.getFieldDescriptor(ClassName.toSlashedClassName(ma.getClassName()), ma.getFieldName(), ma.getFieldSignature(), ma.isStatic());
    }

    public static ClassDescriptor getClassDescriptor(ObjectType type) {
        return DescriptorFactory.instance().getClassDescriptorForDottedClassName(type.getClassName());
    }

    public static ClassDescriptor createClassDescriptor(JavaClass c) {
        return DescriptorFactory.createClassDescriptorFromDottedClassName(c.getClassName());
    }

    public static ClassDescriptor createClassDescriptorFromResourceName(String resourceName) {
        if (!DescriptorFactory.isClassResource(resourceName)) {
            throw new IllegalArgumentException("Resource " + resourceName + " is not a class");
        }
        return DescriptorFactory.createClassDescriptor(resourceName.substring(0, resourceName.length() - 6));
    }

    @CheckForNull
    public static ClassDescriptor createClassDescriptorFromFieldSignature(String signature) {
        int start = signature.indexOf(76);
        if (start < 0) {
            return null;
        }
        int end = signature.indexOf(59, start);
        if (end < 0) {
            return null;
        }
        return DescriptorFactory.createClassDescriptor(signature.substring(start + 1, end));
    }

    public static boolean isClassResource(String resourceName) {
        return resourceName.endsWith(".class");
    }

    public static ClassDescriptor createClassDescriptorFromSignature(String signature) {
        int length = signature.length();
        if (length == 0) {
            throw new IllegalArgumentException("Empty signature");
        }
        if (signature.charAt(0) == 'L' && signature.endsWith(";")) {
            signature = signature.substring(1, signature.length() - 1);
        }
        return DescriptorFactory.createClassDescriptor(signature);
    }

    public static ClassDescriptor createClassOrObjectDescriptorFromSignature(String signature) {
        if (signature.charAt(0) == '[') {
            return DescriptorFactory.createClassDescriptor("java/lang/Object");
        }
        return DescriptorFactory.createClassDescriptorFromSignature(signature);
    }

    public static ClassDescriptor createClassDescriptor(Class<?> aClass) {
        return DescriptorFactory.instance().getClassDescriptor(ClassName.toSlashedClassName(aClass.getName()));
    }

    @Nonnull
    public static ClassDescriptor createClassDescriptor(@SlashedClassName String className) {
        return DescriptorFactory.instance().getClassDescriptor(className);
    }

    public static ClassDescriptor[] createClassDescriptor(String[] classNames) {
        if (classNames.length == 0) {
            return ClassDescriptor.EMPTY_ARRAY;
        }
        ClassDescriptor[] result = new ClassDescriptor[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            result[i] = DescriptorFactory.createClassDescriptor(classNames[i]);
        }
        return result;
    }

    public static ClassDescriptor createClassDescriptorFromDottedClassName(String dottedClassName) {
        return DescriptorFactory.createClassDescriptor(dottedClassName.replace('.', '/'));
    }
}

