/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.gui2.FindBugsAnalysisFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFBAFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFBPFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsHtmlFileFilter;
import edu.umd.cs.findbugs.util.Util;
import java.io.File;

enum SaveType {
    NOT_KNOWN,
    HTML_OUTPUT,
    XML_ANALYSIS,
    FBP_FILE,
    FBA_FILE;


    public FindBugsFileFilter getFilter() {
        switch (this) {
            case XML_ANALYSIS: {
                return FindBugsAnalysisFileFilter.INSTANCE;
            }
            case HTML_OUTPUT: {
                return FindBugsHtmlFileFilter.INSTANCE;
            }
            case FBP_FILE: {
                return FindBugsFBPFileFilter.INSTANCE;
            }
            case FBA_FILE: {
                return FindBugsFBAFileFilter.INSTANCE;
            }
        }
        throw new IllegalArgumentException("No filter for type NOT_UNKNOWN");
    }

    public boolean isValid(File f) {
        if (f.isDirectory()) {
            return false;
        }
        FindBugsFileFilter filter = this.getFilter();
        return filter.accept(f);
    }

    public String getFileExtension() {
        switch (this) {
            case HTML_OUTPUT: {
                return ".html";
            }
            case XML_ANALYSIS: {
                return ".xml";
            }
            case FBP_FILE: {
                return ".fbp";
            }
            case FBA_FILE: {
                return ".fba";
            }
        }
        throw new IllegalArgumentException("No filter for type NOT_UNKNOWN");
    }

    public static SaveType forFile(File f) {
        String extension = Util.getFileExtension(f);
        if (extension.equals("html") || extension.equals("htm")) {
            return HTML_OUTPUT;
        }
        if (extension.equals("fba")) {
            return FBA_FILE;
        }
        if (extension.equals("fbp")) {
            return FBP_FILE;
        }
        if (extension.equals("xml")) {
            return XML_ANALYSIS;
        }
        if (extension.equals("html")) {
            return XML_ANALYSIS;
        }
        if (f.getName().toLowerCase().endsWith("xml.gz")) {
            return XML_ANALYSIS;
        }
        return NOT_KNOWN;
    }
}

