/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.render.FormatOptions;
import org.jboss.jdocbook.render.FormatPlanBuilder;
import org.jboss.jdocbook.render.Renderer;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.RenderingSource;
import org.jboss.jdocbook.render.fop.ResultImpl;
import org.jboss.jdocbook.util.ConsoleRedirectionHandler;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.StandardDocBookFormatMetadata;
import org.jboss.jdocbook.util.TranslationUtils;
import org.jboss.jdocbook.xslt.EntityResolverChain;
import org.jboss.jdocbook.xslt.FormatPlan;
import org.jboss.jdocbook.xslt.LocalDocBookSchemaResolver;
import org.jboss.jdocbook.xslt.XIncludeEntityResolver;
import org.jboss.jdocbook.xslt.XSLTException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class RendererImpl
implements Renderer {
    private static final Logger log = LoggerFactory.getLogger(RendererImpl.class);
    private final JDocBookComponentRegistry componentRegistry;
    private final EntityResolverChain entityResolver;

    public RendererImpl(JDocBookComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
        this.entityResolver = new EntityResolverChain((EntityResolver)componentRegistry.getTransformerBuilder().getCatalogResolver());
        this.entityResolver.addEntityResolver(new LocalDocBookSchemaResolver(componentRegistry.getEnvironment().getDocBookSchemaResolutionStrategy()));
        this.entityResolver.addEntityResolver(new XIncludeEntityResolver(componentRegistry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(RenderingSource source, FormatOptions formatOptions) {
        boolean deleted;
        File targetFile;
        File targetDirectory;
        boolean created;
        String languageStr = this.stringify(source.getLanguage());
        FormatPlan formatPlan = FormatPlanBuilder.buildFormatPlan(formatOptions);
        log.info("Starting rendering {}/{}", (Object)languageStr, (Object)formatPlan.getName());
        File sourceFile = source.resolveSourceDocument();
        if (!sourceFile.exists()) {
            log.warn("Source document {} did not exist; skipping", (Object)sourceFile.getAbsolutePath());
            return;
        }
        File publishingDirectory = source.resolvePublishingBaseDirectory();
        if (!publishingDirectory.exists() && !(created = publishingDirectory.mkdirs())) {
            log.warn("Unable to create publishing directory {}", (Object)publishingDirectory.getAbsolutePath());
        }
        if (!(targetDirectory = new File(publishingDirectory, formatPlan.getName())).exists()) {
            FileUtils.mkdir((String)targetDirectory.getAbsolutePath());
        }
        File stagingDirectory = this.componentRegistry.getEnvironment().getStagingDirectory();
        if (formatPlan.requiresImageCopying() && stagingDirectory.exists()) {
            File cssBase;
            File imageBase = new File(stagingDirectory, "images");
            if (imageBase.exists()) {
                try {
                    FileUtils.copyDirectoryStructure((File)imageBase, (File)targetDirectory);
                }
                catch (IOException e) {
                    throw new RenderingException("unable to copy images", e);
                }
            }
            if ((cssBase = new File(stagingDirectory, "css")).exists()) {
                try {
                    FileUtils.copyDirectoryStructure((File)cssBase, (File)targetDirectory);
                }
                catch (IOException e) {
                    throw new RenderingException("unable to copy css", e);
                }
            }
        }
        if ((targetFile = new File(targetDirectory, this.deduceTargetFileName(sourceFile, formatPlan))).exists() && !(deleted = targetFile.delete())) {
            log.warn("Unable to delete existing target file {}", (Object)targetFile.getAbsolutePath());
        }
        if (!targetFile.exists()) {
            try {
                boolean created2 = targetFile.createNewFile();
                if (!created2) {
                    log.warn("Unable to create target file {}", (Object)targetFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RenderingException("unable to create output file [" + targetFile.getAbsolutePath() + "]", e);
            }
        }
        Transformer transformer = this.buildTransformer(targetFile, formatPlan, stagingDirectory);
        transformer.setParameter("l10n.gentext.language", languageStr);
        ConsoleRedirectionHandler console = new ConsoleRedirectionHandler(this.determineConsoleRedirectFile(source, formatPlan));
        console.start();
        try {
            Source transformationSource = this.buildSource(sourceFile);
            Result transformationResult = this.buildResult(targetFile, formatPlan);
            try {
                transformer.transform(transformationSource, transformationResult);
            }
            catch (TransformerException e) {
                throw new XSLTException("error rendering [" + e.getMessageAndLocation() + "] on " + sourceFile.getName(), e);
            }
            finally {
                this.releaseResult(transformationResult, formatPlan);
            }
        }
        finally {
            console.stop();
        }
    }

    private String stringify(Locale locale) {
        return TranslationUtils.render(locale, this.componentRegistry.getConfiguration().getLocaleSeparator());
    }

    protected Transformer buildTransformer(File targetFile, FormatPlan formatPlan, File stagingDirectory) throws RenderingException, XSLTException {
        URL transformationStylesheet = this.componentRegistry.getEnvironment().getResourceDelegate().requireResource(formatPlan.getStylesheetResource());
        Transformer transformer = this.componentRegistry.getTransformerBuilder().buildTransformer(formatPlan, transformationStylesheet);
        if (formatPlan.requiresSettingImagePath()) {
            try {
                String imgSrcPath = new File(stagingDirectory, "images").toURI().toURL().toString();
                if (!imgSrcPath.endsWith("/")) {
                    imgSrcPath = imgSrcPath + '/';
                }
                log.trace("setting 'img.src.path' xslt parameter {}", (Object)imgSrcPath);
                transformer.setParameter("img.src.path", imgSrcPath);
            }
            catch (MalformedURLException e) {
                throw new XSLTException("unable to prepare 'img.src.path' xslt parameter", e);
            }
        }
        transformer.setParameter("keep.relative.image.uris", this.componentRegistry.getConfiguration().isUseRelativeImageUris() ? "1" : "0");
        transformer.setParameter("base.dir", targetFile.getParent() + File.separator);
        transformer.setParameter("manifest.in.base.dir", "1");
        if (formatPlan.doesChunking()) {
            String rootFilename = targetFile.getName();
            rootFilename = rootFilename.substring(0, rootFilename.lastIndexOf(46));
            transformer.setParameter("root.filename", rootFilename);
        }
        return transformer;
    }

    private File determineConsoleRedirectFile(RenderingSource source, FormatPlan formatPlan) {
        String fileName = "console-" + this.stringify(source.getLanguage()) + "-" + formatPlan.getName() + ".log";
        return new File(new File(this.componentRegistry.getEnvironment().getWorkDirectory(), "log"), fileName);
    }

    private String deduceTargetFileName(File source, FormatPlan formatPlan) {
        return formatPlan.getTargetNamingStrategy().determineTargetFileName(source);
    }

    protected Source buildSource(File sourceFile) throws RenderingException {
        return FileUtils.createSAXSource(sourceFile, this.entityResolver, this.componentRegistry.getConfiguration().getValueInjections());
    }

    protected Result buildResult(File targetFile, FormatPlan formatPlan) throws RenderingException, XSLTException {
        if (StandardDocBookFormatMetadata.PDF.getName().equals(formatPlan.getName())) {
            return new ResultImpl(targetFile, this.componentRegistry);
        }
        return new StreamResult(targetFile);
    }

    protected void releaseResult(Result transformationResult, FormatPlan formatPlan) {
        if (StandardDocBookFormatMetadata.PDF.getName().equals(formatPlan.getName())) {
            ((ResultImpl)transformationResult).release();
        }
    }
}

