/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.jdocbook.DocBookSchemaResolutionStrategy;
import org.jboss.jdocbook.xslt.EntityResolverChain;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocalDocBookSchemaResolver
extends EntityResolverChain {
    public static final String BASE_PUBLIC_ID = "http://docbook.org/ns/docbook";
    public static final String SYSTEM_ID_PREFIX = "http://docbook.org/xml/";
    public static final int SYSTEM_ID_PREFIX_LEN = "http://docbook.org/xml/".length();
    private static final InternalEntityResolver DTD_RESOLVER = new DocBookDtdResolver();
    private static final InternalEntityResolver XSD_RESOLVER = new DocBookXsdResolver();
    private static final InternalEntityResolver RNG_RESOLVER = new DocBookRngResolver();
    private static final InternalEntityResolver RNC_RESOLVER = new DocBookRncResolver();
    private static final InternalEntityResolver SCH_RESOLVER = new DocBookSchResolver();
    private static final LegacyDocBookDtdResolver LEGACY_DTD_RESOLVER = new LegacyDocBookDtdResolver();

    public LocalDocBookSchemaResolver(DocBookSchemaResolutionStrategy schemaResolutionStrategy) {
        super(new BasePublicIdSchemaResolver(schemaResolutionStrategy));
        this.addEntityResolver(DTD_RESOLVER);
        this.addEntityResolver(XSD_RESOLVER);
        this.addEntityResolver(RNG_RESOLVER);
        this.addEntityResolver(RNC_RESOLVER);
        this.addEntityResolver(SCH_RESOLVER);
        this.addEntityResolver(LEGACY_DTD_RESOLVER);
    }

    private static InputSource wrap(InputStream stream, String publicId, String systemId) {
        if (stream != null) {
            InputSource source = new InputSource(stream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        return null;
    }

    public static class LegacyDocBookDtdResolver
    extends DocBookDtdResolver {
        public static final String SYSTEM_ID_PREFIX = "http://www.oasis-open.org/docbook/xml/";
        public static final int SYSTEM_ID_PREFIX_LEN = "http://www.oasis-open.org/docbook/xml/".length();

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            int versionEndTokenPosition;
            String name;
            InputStream stream;
            if (systemId == null) {
                return null;
            }
            if (systemId.startsWith(SYSTEM_ID_PREFIX) && (stream = this.resolveStream(name = systemId.substring((versionEndTokenPosition = systemId.indexOf(47, SYSTEM_ID_PREFIX_LEN)) + 1))) != null) {
                InputSource source = new InputSource(stream);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            return null;
        }
    }

    public static class DocBookSchResolver
    extends AbstractInternalResolver {
        @Override
        public String getType() {
            return "sch";
        }
    }

    public static class DocBookRncResolver
    extends AbstractInternalResolver {
        @Override
        public String getType() {
            return "rnc";
        }
    }

    public static class DocBookRngResolver
    extends AbstractInternalResolver {
        @Override
        public String getType() {
            return "rng";
        }
    }

    public static class DocBookXsdResolver
    extends AbstractInternalResolver {
        @Override
        public String getType() {
            return "xsd";
        }
    }

    public static class DocBookDtdResolver
    extends AbstractInternalResolver {
        @Override
        public String getType() {
            return "dtd";
        }
    }

    public static abstract class AbstractInternalResolver
    implements InternalEntityResolver {
        public abstract String getType();

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            int versionEndTokenPosition;
            String name;
            InputStream stream;
            if (systemId == null) {
                return null;
            }
            if (systemId.startsWith(LocalDocBookSchemaResolver.SYSTEM_ID_PREFIX) && (stream = this.resolveStream(name = systemId.substring((versionEndTokenPosition = systemId.indexOf(47, SYSTEM_ID_PREFIX_LEN)) + 1))) != null) {
                InputSource source = new InputSource(stream);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            return null;
        }

        @Override
        public InputStream resolveStream(String resource) {
            String resourceName = "docbook/" + this.getType() + "/" + resource;
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            if (stream == null) {
                stream = this.getClass().getClassLoader().getResourceAsStream('/' + resourceName);
            }
            return stream;
        }

        @Override
        public String getMainDocBookSchemaName() {
            return "docbook." + this.getType();
        }
    }

    public static class BasePublicIdSchemaResolver
    implements EntityResolver {
        private final InternalEntityResolver indicatedResolver;

        public BasePublicIdSchemaResolver(DocBookSchemaResolutionStrategy schemaResolutionStrategy) {
            switch (schemaResolutionStrategy) {
                case DTD: {
                    this.indicatedResolver = DTD_RESOLVER;
                    break;
                }
                case XSD: {
                    this.indicatedResolver = XSD_RESOLVER;
                    break;
                }
                case RNC: {
                    this.indicatedResolver = RNC_RESOLVER;
                    break;
                }
                case SCH: {
                    this.indicatedResolver = SCH_RESOLVER;
                    break;
                }
                default: {
                    this.indicatedResolver = RNG_RESOLVER;
                }
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (publicId == null) {
                return null;
            }
            if (publicId.equals(LocalDocBookSchemaResolver.BASE_PUBLIC_ID)) {
                return LocalDocBookSchemaResolver.wrap(this.indicatedResolver.resolveStream(this.indicatedResolver.getMainDocBookSchemaName()), publicId, systemId);
            }
            return null;
        }
    }

    private static interface InternalEntityResolver
    extends EntityResolver {
        public InputStream resolveStream(String var1);

        public String getMainDocBookSchemaName();
    }
}

