/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render.fop;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.sax.SAXResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.events.EventListener;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.fop.EventListenerBridge;
import org.jboss.jdocbook.render.fop.FopConfigHelper;

public class ResultImpl
extends SAXResult {
    private OutputStream outputStream;

    public ResultImpl(File targetFile, JDocBookComponentRegistry componentRegistry) throws RenderingException {
        try {
            this.outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
            FopFactory fopFactory = FopFactory.newInstance();
            fopFactory.setUserConfig((Configuration)FopConfigHelper.getFopConfiguration(componentRegistry));
            FOUserAgent fopUserAgent = fopFactory.newFOUserAgent();
            fopUserAgent.setProducer("jDocBook - Java-based DocBook processor");
            fopUserAgent.getEventBroadcaster().addEventListener((EventListener)new EventListenerBridge());
            Fop fop = fopFactory.newFop("application/pdf", fopUserAgent, this.outputStream);
            this.setHandler(fop.getDefaultHandler());
        }
        catch (Throwable t) {
            throw new RenderingException("error building transformation result [" + targetFile.getAbsolutePath() + "]", t);
        }
    }

    public void release() {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

