/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.translate;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.translate.PoSynchronizer;
import org.jboss.jdocbook.translate.TranslationSource;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.TranslationUtils;
import org.jboss.jdocbook.util.VCSDirectoryExclusionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoSynchronizerImpl
implements PoSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(PoSynchronizerImpl.class);
    private final JDocBookComponentRegistry componentRegistry;

    public PoSynchronizerImpl(JDocBookComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    @Override
    public void synchronizePo(TranslationSource source) {
        this.synchronizePo(this.componentRegistry.getEnvironment().getMasterLanguageDescriptor().getPotDirectory(), source.resolvePoDirectory(), source.getLanguage());
    }

    private void synchronizePo(File potDirectory, File poDirectory, Locale translationLocale) throws JDocBookProcessException {
        if (!potDirectory.exists()) {
            log.info("skipping PO updates; POT directory did not exist : {0}", (Object)potDirectory);
            return;
        }
        File[] files = potDirectory.listFiles(new VCSDirectoryExclusionFilter());
        int X = files.length;
        for (int i = 0; i < X; ++i) {
            if (files[i].isDirectory()) {
                this.synchronizePo(new File(potDirectory, files[i].getName()), new File(poDirectory, files[i].getName()), translationLocale);
                continue;
            }
            if (!TranslationUtils.isPotFile(files[i])) continue;
            File translation = new File(poDirectory, TranslationUtils.determinePoFileName(files[i]));
            this.updateTranslation(files[i], translation, translationLocale);
        }
    }

    private void updateTranslation(File template, File translation, Locale translationLocale) {
        CommandLine commandLine;
        if (!template.exists()) {
            log.trace("skipping PO updates; POT file did not exist : {0}", (Object)template);
            return;
        }
        if (translation.lastModified() >= template.lastModified()) {
            log.trace("skipping PO updates; up-to-date : {0}", (Object)translation);
            return;
        }
        String translationLocaleString = this.componentRegistry.toLanguageString(translationLocale);
        if (translation.exists()) {
            commandLine = CommandLine.parse((String)"msgmerge");
            commandLine.addArgument("--quiet");
            commandLine.addArgument("--update");
            commandLine.addArgument("--backup=none");
            commandLine.addArgument(FileUtils.resolveFullPathName(translation));
            commandLine.addArgument(FileUtils.resolveFullPathName(template));
        } else {
            boolean created;
            if (!translation.getParentFile().exists() && !(created = translation.getParentFile().mkdirs())) {
                log.info("Unable to create PO directory {}", (Object)translation.getParentFile().getAbsolutePath());
            }
            commandLine = CommandLine.parse((String)"msginit");
            commandLine.addArgument("--no-translator");
            commandLine.addArgument("--locale=" + translationLocaleString);
            commandLine.addArgument("-i");
            commandLine.addArgument(FileUtils.resolveFullPathName(template));
            commandLine.addArgument("-o");
            commandLine.addArgument(FileUtils.resolveFullPathName(translation));
        }
        log.info("po-synch -> " + commandLine.toString());
        DefaultExecutor executor = new DefaultExecutor();
        try {
            executor.execute(commandLine);
        }
        catch (IOException e) {
            throw new JDocBookProcessException("Error synchronizing PO file [" + template.getName() + "] for " + translationLocaleString, e);
        }
    }
}

