/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.sax.SAXSource;
import net.socialchange.doctype.Doctype;
import net.socialchange.doctype.DoctypeChangerStream;
import net.socialchange.doctype.DoctypeGenerator;
import net.socialchange.doctype.DoctypeImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.ValueInjection;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FileUtils
extends org.codehaus.plexus.util.FileUtils {
    public static SAXSource createSAXSource(File file, EntityResolver resolver, LinkedHashSet<ValueInjection> valueInjections) {
        try {
            InputSource source = FileUtils.createInputSource(file, valueInjections);
            SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
            factory.setXIncludeAware(true);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setEntityResolver(resolver);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            return new SAXSource(reader, source);
        }
        catch (ParserConfigurationException e) {
            throw new JDocBookProcessException("unable to build SAX Parser/Factory [" + e.getMessage() + "]", e);
        }
        catch (SAXException e) {
            throw new JDocBookProcessException("unable to build SAX Parser/Factory [" + e.getMessage() + "]", e);
        }
    }

    public static InputSource createInputSource(File file, LinkedHashSet<ValueInjection> valueInjections) {
        try {
            InputSource source = new InputSource(FileUtils.createInputStream(file, valueInjections));
            source.setSystemId(file.toURI().toURL().toString());
            return source;
        }
        catch (MalformedURLException e) {
            throw new JDocBookProcessException("unexpected problem converting file to URL", e);
        }
    }

    public static InputStream createInputStream(File file, final LinkedHashSet<ValueInjection> valueInjections) {
        boolean injectionsDefined = valueInjections != null && !valueInjections.isEmpty();
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            if (injectionsDefined) {
                DoctypeChangerStream changerStream = new DoctypeChangerStream((InputStream)inputStream);
                changerStream.setGenerator(new DoctypeGenerator(){

                    public Doctype generate(Doctype doctype) {
                        String root = doctype == null ? null : doctype.getRootElement();
                        String pubId = doctype == null ? null : doctype.getPublicId();
                        String sysId = doctype == null ? null : doctype.getSystemId();
                        StringBuilder internalSubset = FileUtils.buildInjectedEntitySubset(valueInjections);
                        if (doctype != null && doctype.getInternalSubset() != null) {
                            internalSubset.append(doctype.getInternalSubset()).append('\n');
                        }
                        return new DoctypeImpl(root, pubId, sysId, internalSubset.toString());
                    }
                });
                inputStream = changerStream;
            }
            return inputStream;
        }
        catch (FileNotFoundException e) {
            throw new JDocBookProcessException("unable to locate source file", e);
        }
    }

    public static String determineRelativity(File file, File basedir) {
        String directory;
        String basedirPath = FileUtils.resolveFullPathName(basedir);
        if (basedirPath.equals(directory = FileUtils.resolveFullPathName(file.getParentFile()))) {
            return null;
        }
        int baseStart = directory.indexOf(basedirPath);
        if (baseStart < 0) {
            throw new RuntimeException("Included file did not seem to be relative to basedir!");
        }
        String relativity = directory.substring(basedirPath.length() + 1);
        while (relativity.startsWith("/")) {
            relativity = relativity.substring(1);
        }
        return relativity;
    }

    public static boolean isXMLFile(File file) {
        return file != null && file.exists() && file.getName().endsWith(".xml");
    }

    public static String resolveFullPathName(File path) {
        return path.getAbsolutePath();
    }

    public static StringBuilder buildInjectedEntitySubset(Set<ValueInjection> valueInjections) {
        StringBuilder buffer = new StringBuilder();
        for (ValueInjection injection : valueInjections) {
            buffer.append("<!ENTITY ").append(injection.getName()).append(" \"").append(injection.getValue()).append("\">\n");
        }
        return buffer;
    }
}

