/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.jboss.jdocbook.xslt.AbstractCatalogManager;

public class ImplicitCatalogManager
extends AbstractCatalogManager {
    public ImplicitCatalogManager() {
        super(ImplicitCatalogManager.resolveCatalogNames());
    }

    private static LinkedHashSet<String> resolveCatalogNames() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ImplicitCatalogManager.class.getClassLoader();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        try {
            Enumeration<URL> enumeration = classLoader.getResources("catalog.xml");
            while (enumeration.hasMoreElements()) {
                URL resource = enumeration.nextElement();
                String resourcePath = resource.toExternalForm();
                if (resourcePath == null) continue;
                names.add(resourcePath);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return names;
    }
}

