/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnusedImportsCheck
extends Check {
    private boolean mCollect;
    private boolean mProcessJavadoc;
    private final Set<FullIdent> mImports = Sets.newHashSet();
    private final Set<String> mReferenced = Sets.newHashSet();

    public void setProcessJavadoc(boolean aValue) {
        this.mProcessJavadoc = aValue;
    }

    public void beginTree(DetailAST aRootAST) {
        this.mCollect = false;
        this.mImports.clear();
        this.mReferenced.clear();
    }

    public void finishTree(DetailAST aRootAST) {
        for (FullIdent imp : this.mImports) {
            if (this.mReferenced.contains(Utils.baseClassname(imp.getText()))) continue;
            this.log(imp.getLineNo(), imp.getColumnNo(), "import.unused", imp.getText());
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{58, 30, 152, 16, 157, 161, 154, 155, 14, 15, 9, 8, 10};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 58) {
            if (this.mCollect) {
                this.processIdent(aAST);
            }
        } else if (aAST.getType() == 30) {
            this.processImport(aAST);
        } else if (aAST.getType() == 152) {
            this.processStaticImport(aAST);
        } else {
            this.mCollect = true;
            if (this.mProcessJavadoc) {
                this.processJavadoc(aAST);
            }
        }
    }

    private void processIdent(DetailAST aAST) {
        DetailAST parent = aAST.getParent();
        int parentType = parent.getType();
        if (parentType != 59 && parentType != 9 || parentType == 59 && aAST.getNextSibling() != null) {
            this.mReferenced.add(aAST.getText());
        }
    }

    private void processImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdentBelow(aAST);
        if (name != null && !name.getText().endsWith(".*")) {
            this.mImports.add(name);
        }
    }

    private void processStaticImport(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdent(aAST.getFirstChild().getNextSibling());
        if (name != null && !name.getText().endsWith(".*")) {
            this.mImports.add(name);
        }
    }

    private void processJavadoc(DetailAST aAST) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock cmt = contents.getJavadocBefore(lineNo = aAST.getLineNo());
        if (cmt != null) {
            JavadocTags tags = JavadocUtils.getJavadocTags(cmt, JavadocUtils.JavadocTagType.ALL);
            for (JavadocTag tag : tags.getValidTags()) {
                if (!tag.canReferenceImports()) continue;
                String identifier = tag.getArg1();
                Pattern pattern = Utils.getPattern("(.+?)(?:\\s+|#|\\$).*");
                Matcher matcher = pattern.matcher(identifier);
                if (matcher.find()) {
                    identifier = matcher.group(1);
                }
                this.mReferenced.add(identifier);
            }
        }
    }
}

