/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.bugReporter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.ComponentPlugin;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.bugReporter.BugReporterDecorator;
import edu.umd.cs.findbugs.charsets.UserTextFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;

public class SuppressionDecorator
extends BugReporterDecorator {
    final String category;
    final HashSet<String> check = new HashSet();
    final HashSet<String> dontCheck = new HashSet();

    public SuppressionDecorator(ComponentPlugin<BugReporterDecorator> plugin, BugReporter delegate) {
        super(plugin, delegate);
        this.category = plugin.getProperties().getProperty("category");
        if (DetectorFactoryCollection.instance().getBugCategory(this.category) == null) {
            throw new IllegalArgumentException("Unable to find category " + this.category);
        }
        String adjustmentSource = plugin.getProperties().getProperty("packageSource");
        String packageList = plugin.getProperties().getProperty("packageList");
        try {
            if (packageList != null) {
                this.processPackageList(new StringReader(packageList));
            }
            if (adjustmentSource != null) {
                URL u;
                if (adjustmentSource.startsWith("file:") || adjustmentSource.startsWith("http:") || adjustmentSource.startsWith("https:")) {
                    u = new URL(adjustmentSource);
                } else {
                    u = plugin.getPlugin().getResource(adjustmentSource);
                    if (u == null) {
                        u = DetectorFactoryCollection.getCoreResource(adjustmentSource);
                    }
                }
                if (u != null) {
                    BufferedReader rawIn = UserTextFile.bufferedReader(u.openStream());
                    this.processPackageList(rawIn);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load " + this.category + " filters from " + adjustmentSource, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPackageList(@WillClose Reader rawIn) throws IOException {
        try (BufferedReader in = new BufferedReader(rawIn);){
            String s;
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() == 0) continue;
                String packageName = s.substring(1).trim();
                if (s.charAt(0) == '+') {
                    this.check.add(packageName);
                    this.dontCheck.remove(packageName);
                    continue;
                }
                if (s.charAt(0) == '-') {
                    this.dontCheck.add(packageName);
                    this.check.remove(packageName);
                    continue;
                }
                throw new IllegalArgumentException("Can't parse " + this.category + " filter line: " + s);
            }
        }
        finally {
            rawIn.close();
        }
    }

    @Override
    public void reportBug(@Nonnull BugInstance bugInstance) {
        if (!this.category.equals(bugInstance.getBugPattern().getCategory())) {
            this.getDelegate().reportBug(bugInstance);
            return;
        }
        if (this.check.isEmpty()) {
            return;
        }
        ClassAnnotation c = bugInstance.getPrimaryClass();
        String packageName = c.getPackageName();
        while (true) {
            if (this.check.contains(packageName)) {
                this.getDelegate().reportBug(bugInstance);
                return;
            }
            if (this.dontCheck.contains(packageName)) {
                return;
            }
            int i = packageName.lastIndexOf(46);
            if (i < 0) {
                return;
            }
            packageName = packageName.substring(0, i);
        }
    }
}

