/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.PruneUnconditionalExceptionThrowerEdges;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class CloneIdiom
extends DismantleBytecode
implements Detector,
StatelessDetector {
    private final ClassDescriptor cloneDescriptor = DescriptorFactory.createClassDescriptor(Cloneable.class);
    boolean isCloneable;
    boolean hasCloneMethod;
    boolean cloneIsDeprecated;
    MethodAnnotation cloneMethodAnnotation;
    boolean referencesCloneMethod;
    boolean invokesSuperClone;
    boolean isFinal;
    boolean cloneOnlyThrowsException;
    boolean check;
    boolean implementsCloneableDirectly;
    private final BugReporter bugReporter;

    public CloneIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept(this);
    }

    @Override
    public void visit(Code obj) {
        if (this.getMethodName().equals("clone") && this.getMethodSig().startsWith("()")) {
            super.visit(obj);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 183 && this.getNameConstantOperand().equals("clone") && this.getSigConstantOperand().startsWith("()")) {
            this.invokesSuperClone = true;
        }
    }

    @Override
    public void visit(JavaClass obj) {
        String[] interface_names;
        this.implementsCloneableDirectly = false;
        this.invokesSuperClone = false;
        this.cloneOnlyThrowsException = false;
        this.isCloneable = false;
        this.check = false;
        this.isFinal = obj.isFinal();
        if (obj.isInterface()) {
            return;
        }
        if (obj.isAbstract()) {
            return;
        }
        for (String interface_name : interface_names = obj.getInterfaceNames()) {
            if (!interface_name.equals("java.lang.Cloneable")) continue;
            this.implementsCloneableDirectly = true;
            this.isCloneable = true;
            break;
        }
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        try {
            if (subtypes2.isSubtype(this.getClassDescriptor(), this.cloneDescriptor)) {
                this.isCloneable = true;
            }
            if (subtypes2.isSubtype(DescriptorFactory.createClassDescriptorFromDottedClassName(obj.getSuperclassName()), this.cloneDescriptor)) {
                this.implementsCloneableDirectly = false;
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        this.hasCloneMethod = false;
        this.referencesCloneMethod = false;
        this.check = true;
        super.visit(obj);
    }

    @Override
    public void visitAfter(JavaClass obj) {
        if (!this.check) {
            return;
        }
        if (this.cloneOnlyThrowsException) {
            return;
        }
        if (this.implementsCloneableDirectly && !this.hasCloneMethod && !this.referencesCloneMethod) {
            this.bugReporter.reportBug(new BugInstance(this, "CN_IDIOM", 2).addClass(this));
        }
        if (this.hasCloneMethod && this.isCloneable && !this.invokesSuperClone && !this.isFinal && obj.isPublic()) {
            int priority = 3;
            if (obj.isPublic() || obj.isProtected()) {
                priority = 2;
            }
            try {
                Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                Set<ClassDescriptor> directSubtypes = subtypes2.getDirectSubtypes(this.getClassDescriptor());
                if (!directSubtypes.isEmpty()) {
                    --priority;
                }
                BugInstance bug = new BugInstance(this, "CN_IDIOM_NO_SUPER_CALL", priority).addClass(this).addMethod(this.cloneMethodAnnotation);
                for (ClassDescriptor d : directSubtypes) {
                    bug.addClass(d).describe("CLASS_SUBCLASS");
                }
                this.bugReporter.reportBug(bug);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        } else if (!(!this.hasCloneMethod || this.isCloneable || this.cloneOnlyThrowsException || this.cloneIsDeprecated || obj.isAbstract())) {
            int priority = 2;
            if (this.referencesCloneMethod) {
                --priority;
            }
            this.bugReporter.reportBug(new BugInstance(this, "CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE", priority).addClass(this).addMethod(this.cloneMethodAnnotation));
        }
    }

    @Override
    public void visit(ConstantNameAndType obj) {
        String methodName = obj.getName(this.getConstantPool());
        String methodSig = obj.getSignature(this.getConstantPool());
        if (!methodName.equals("clone")) {
            return;
        }
        if (!methodSig.startsWith("()")) {
            return;
        }
        this.referencesCloneMethod = true;
    }

    @Override
    public void visit(Method obj) {
        if (obj.isAbstract() || BCELUtil.isSynthetic(obj)) {
            return;
        }
        if (!obj.isPublic()) {
            return;
        }
        if (!this.getMethodName().equals("clone")) {
            return;
        }
        if (!this.getMethodSig().startsWith("()")) {
            return;
        }
        this.hasCloneMethod = true;
        this.cloneIsDeprecated = this.getXMethod().isDeprecated();
        this.cloneMethodAnnotation = MethodAnnotation.fromVisitedMethod(this);
        this.cloneOnlyThrowsException = PruneUnconditionalExceptionThrowerEdges.doesMethodUnconditionallyThrowException(XFactory.createXMethod(this));
    }

    @Override
    public void report() {
    }
}

