/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;

public class InefficientIndexOf
extends OpcodeStackDetector {
    private final BugReporter bugReporter;

    public InefficientIndexOf(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void sawOpcode(int seen) {
        boolean lastIndexOf;
        if (seen == 182 && this.stack.getStackDepth() > 0 && this.getClassConstantOperand().equals("java/lang/String") && ((lastIndexOf = this.getNameConstantOperand().equals("lastIndexOf")) || this.getNameConstantOperand().equals("indexOf"))) {
            OpcodeStack.Item item;
            Object o;
            int stackOff = -1;
            if (this.getSigConstantOperand().equals("(Ljava/lang/String;)I")) {
                stackOff = 0;
            } else if (this.getSigConstantOperand().equals("(Ljava/lang/String;I)I")) {
                stackOff = 1;
            }
            if (stackOff > -1 && (o = (item = this.stack.getStackItem(stackOff)).getConstant()) != null && ((String)o).length() == 1) {
                this.bugReporter.reportBug(new BugInstance(this, lastIndexOf ? "IIO_INEFFICIENT_LAST_INDEX_OF" : "IIO_INEFFICIENT_INDEX_OF", 3).addClassAndMethod(this).describe("STRING_MESSAGE").addCalledMethod(this).addSourceLine(this));
            }
        }
    }
}

