/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.docant.task;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.docant.task.DirectoryLayout;
import org.jboss.docant.task.Format;
import org.jboss.docant.task.Options;
import org.jboss.jdocbook.Configuration;
import org.jboss.jdocbook.DocBookSchemaResolutionStrategy;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.MasterLanguageDescriptor;
import org.jboss.jdocbook.Profiling;
import org.jboss.jdocbook.ResourceDelegate;
import org.jboss.jdocbook.ValueInjection;
import org.jboss.jdocbook.profile.ProfilingSource;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.RenderingSource;
import org.jboss.jdocbook.util.ResourceDelegateSupport;
import org.jboss.jdocbook.util.TranslationUtils;
import org.jboss.jdocbook.util.XIncludeHelper;
import org.jboss.jdocbook.xslt.XSLTException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocbookTask
extends Task
implements DirectoryLayout.BaseInfo {
    private static final Logger log = LoggerFactory.getLogger(AbstractDocbookTask.class);
    protected String sourceDocumentName;
    protected File sourceDirectory;
    protected File baseOutputDirectory;
    protected File fontsDirectory;
    protected List<Format> formats = new ArrayList<Format>();
    protected Profiling profiling = new Profiling();
    protected Options options;
    protected String masterTranslation = "en-US";
    protected boolean ignoreTranslations = false;
    protected String[] translations;
    protected final DirectoryLayout directoryLayout = new DirectoryLayout(this);
    private JDocBookComponentRegistry jDocBookComponentRegistry;
    private Locale masterLanguageLocale;
    private MasterLanguageDescriptorImpl masterLanguageDescriptor = new MasterLanguageDescriptorImpl();
    private File rootMasterSourceFile;

    protected JDocBookComponentRegistry getComponentRegistry() {
        if (this.jDocBookComponentRegistry == null) {
            this.jDocBookComponentRegistry = this.buildComponentRegistry();
        }
        return this.jDocBookComponentRegistry;
    }

    private JDocBookComponentRegistry buildComponentRegistry() {
        return new JDocBookComponentRegistry((Environment)new EnvironmentImpl(), (Configuration)new ConfigurationImpl());
    }

    protected Locale getMasterLanguageLocale() {
        if (this.masterLanguageLocale == null) {
            this.masterLanguageLocale = this.fromLanguageString(this.getMasterLanguage());
        }
        return this.masterLanguageLocale;
    }

    public Locale fromLanguageString(String languageStr) {
        return TranslationUtils.parse((String)languageStr, (char)this.options.getLocaleSeparator());
    }

    private boolean isMasterLanguage(String language) {
        return this.getMasterLanguage().equals(language);
    }

    private boolean isMasterLanguage(Locale language) {
        return this.getMasterLanguageLocale().equals(language);
    }

    public MasterLanguageDescriptorImpl getMasterLanguageDescriptor() {
        return this.masterLanguageDescriptor;
    }

    protected void process() throws JDocBookProcessException {
    }

    protected void doExecute() throws JDocBookProcessException {
        this.process();
    }

    public void execute() throws BuildException {
        if (this.options == null) {
            this.options = new Options();
        }
        if (this.translations == null) {
            this.translations = new String[0];
        }
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.addResourceIntoClassloader();
            this.doExecute();
        }
        catch (XSLTException e) {
            throw new BuildException("XSLT problem", (Throwable)e);
        }
        catch (RenderingException e) {
            throw new BuildException("Rendering problem", (Throwable)e);
        }
        catch (JDocBookProcessException e) {
            throw new BuildException("Unexpected problem", (Throwable)e);
        }
    }

    private void addResourceIntoClassloader() {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.directoryLayout.getStagingDirectory().exists()) {
            try {
                urls.add(this.directoryLayout.getStagingDirectory().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new JDocBookProcessException("Unable to resolve staging directory to URL", (Throwable)e);
            }
        }
        URLClassLoader newCl = new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(newCl);
    }

    private ClassLoader buildResourceDelegateClassLoader() {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.directoryLayout.getStagingDirectory().exists()) {
            try {
                urls.add(this.directoryLayout.getStagingDirectory().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new JDocBookProcessException("Unable to resolve staging directory to URL", (Throwable)e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
    }

    protected File getRootMasterSourceFile() {
        if (this.rootMasterSourceFile == null) {
            this.rootMasterSourceFile = new File(this.directoryLayout.getMasterSourceDirectory(), this.sourceDocumentName);
        }
        return this.rootMasterSourceFile;
    }

    protected String stringify(Locale locale) {
        return TranslationUtils.render((Locale)locale, (char)this.options.getLocaleSeparator());
    }

    protected File getSourceDocument(Locale languageLocale) {
        return this.getSourceDocument(this.stringify(languageLocale));
    }

    protected File getSourceDocument(String language) {
        return this.isMasterLanguage(language) ? this.getRootMasterSourceFile() : new File(this.directoryLayout.getTranslationDirectory(language), this.sourceDocumentName);
    }

    protected File getProfiledDocument(Locale languageLocale) {
        return this.getProfiledDocument(this.stringify(languageLocale));
    }

    protected File getProfiledDocument(String language) {
        return new File(this.directoryLayout.getProfilingDirectory(language), this.sourceDocumentName);
    }

    protected List<Format> getFormatOptionsList() {
        return this.formats;
    }

    protected List<PublishingSource> resolvePublishingSources() {
        ArrayList<PublishingSource> sources = new ArrayList<PublishingSource>();
        if (this.ignoreTranslations) {
            sources.add(new PublishingSource(this.getMasterLanguageLocale()));
        } else {
            sources.add(new PublishingSource(this.getMasterLanguageLocale()));
            for (String language : this.translations) {
                Locale languageLocale = this.fromLanguageString(language);
                sources.add(new PublishingSource(languageLocale));
            }
        }
        return sources;
    }

    public String getSourceDocumentName() {
        return this.sourceDocumentName;
    }

    public void setSourceDocumentName(String sourceDocumentName) {
        this.sourceDocumentName = sourceDocumentName;
    }

    @Override
    public File getBaseSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    @Override
    public File getBaseOutputDirectory() {
        return this.baseOutputDirectory;
    }

    public void setBaseOutputDirectory(File baseOutputDirectory) {
        this.baseOutputDirectory = baseOutputDirectory;
    }

    public File[] getFontDirectories() {
        File stagedFontsDirectory;
        ArrayList<File> directories = new ArrayList<File>();
        if (this.fontsDirectory != null && this.fontsDirectory.exists()) {
            directories.add(this.fontsDirectory);
        }
        if ((stagedFontsDirectory = new File(this.directoryLayout.getStagingDirectory(), "fonts")).exists()) {
            directories.add(stagedFontsDirectory);
        }
        return directories.toArray(new File[directories.size()]);
    }

    public File getFontsDirectory() {
        return this.fontsDirectory;
    }

    public void setFontsDirectory(File fontsDirectory) {
        this.fontsDirectory = fontsDirectory;
    }

    public Format createFormat() {
        Format f = new Format();
        this.formats.add(f);
        return f;
    }

    @Override
    public String getMasterLanguage() {
        return this.masterTranslation;
    }

    public String getMasterTranslation() {
        return this.masterTranslation;
    }

    public void setMasterTranslation(String masterTranslation) {
        this.masterTranslation = masterTranslation;
    }

    protected class PublishingSource
    implements ProfilingSource,
    RenderingSource {
        private final Locale languageLocale;

        public PublishingSource(Locale languageLocale) {
            this.languageLocale = languageLocale;
        }

        public Locale getLanguage() {
            return this.languageLocale;
        }

        public File resolveDocumentFile() {
            return AbstractDocbookTask.this.getSourceDocument(this.getLanguage());
        }

        public File resolveProfiledDocumentFile() {
            return AbstractDocbookTask.this.getProfiledDocument(this.languageLocale);
        }

        public File resolveSourceDocument() {
            return AbstractDocbookTask.this.profiling.isEnabled() ? AbstractDocbookTask.this.getProfiledDocument(this.languageLocale) : AbstractDocbookTask.this.getSourceDocument(this.languageLocale);
        }

        public File resolvePublishingBaseDirectory() {
            return AbstractDocbookTask.this.directoryLayout.getPublishBaseDirectory(AbstractDocbookTask.this.stringify(this.languageLocale));
        }

        public File getXslFoDirectory() {
            return null;
        }
    }

    private class ConfigurationImpl
    implements Configuration {
        private LinkedHashSet<ValueInjection> valueInjections;
        private LinkedHashSet<String> catalogSet;

        private ConfigurationImpl() {
        }

        private Options options() {
            return AbstractDocbookTask.this.options;
        }

        public Map<String, String> getTransformerParameters() {
            return this.options().getTransformerParameters();
        }

        public boolean isUseRelativeImageUris() {
            return this.options().isUseRelativeImageUris();
        }

        public char getLocaleSeparator() {
            return this.options().getLocaleSeparator();
        }

        public boolean isAutoDetectFontsEnabled() {
            return this.options().isAutoDetectFontsEnabled();
        }

        public boolean isUseFopFontCacheEnabled() {
            return this.options().isUseFopFontCache();
        }

        public LinkedHashSet<ValueInjection> getValueInjections() {
            if (this.valueInjections == null) {
                this.valueInjections = new LinkedHashSet();
                this.valueInjections.addAll(this.getValueInjections());
                if (this.options().isApplyStandardInjectionValues()) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(this.options().getInjectionDateFormat());
                    this.valueInjections.add(new ValueInjection("today", dateFormat.format(new Date())));
                }
            }
            return this.valueInjections;
        }

        public LinkedHashSet<String> getCatalogs() {
            if (this.catalogSet == null) {
                this.catalogSet = new LinkedHashSet();
                for (String catalog : this.options().getCatalogs()) {
                    this.catalogSet.add(catalog);
                }
            }
            return this.catalogSet;
        }

        public Profiling getProfiling() {
            return AbstractDocbookTask.this.profiling;
        }

        public String getDocBookVersion() {
            return AbstractDocbookTask.this.options.getDocbookVersion();
        }
    }

    private class ResourceDelegateImpl
    extends ResourceDelegateSupport {
        private ClassLoader loader;

        private ResourceDelegateImpl() {
        }

        protected ClassLoader getResourceClassLoader() {
            if (this.loader == null) {
                this.loader = AbstractDocbookTask.this.buildResourceDelegateClassLoader();
            }
            return this.loader;
        }
    }

    private class EnvironmentImpl
    implements Environment {
        private final ResourceDelegateImpl resourceDelegate;

        private EnvironmentImpl() {
            this.resourceDelegate = new ResourceDelegateImpl();
        }

        public ResourceDelegate getResourceDelegate() {
            return this.resourceDelegate;
        }

        public MasterLanguageDescriptor getMasterLanguageDescriptor() {
            return this.getMasterLanguageDescriptor();
        }

        public File getWorkDirectory() {
            return AbstractDocbookTask.this.directoryLayout.getRootJDocBookWorkDirectory();
        }

        public File getStagingDirectory() {
            return AbstractDocbookTask.this.directoryLayout.getStagingDirectory();
        }

        public List<File> getFontDirectories() {
            return Arrays.asList(AbstractDocbookTask.this.getFontDirectories());
        }

        public Environment.DocBookXsltResolutionStrategy getDocBookXsltResolutionStrategy() {
            return Environment.DocBookXsltResolutionStrategy.NAMED;
        }

        public DocBookSchemaResolutionStrategy getDocBookSchemaResolutionStrategy() {
            return DocBookSchemaResolutionStrategy.XSD;
        }
    }

    private class MasterLanguageDescriptorImpl
    implements MasterLanguageDescriptor {
        private File rootMasterFile;
        private Set<File> masterFiles;

        private MasterLanguageDescriptorImpl() {
        }

        public Locale getLanguage() {
            return AbstractDocbookTask.this.fromLanguageString(AbstractDocbookTask.this.masterTranslation);
        }

        public File getPotDirectory() {
            return AbstractDocbookTask.this.directoryLayout.getPotSourceDirectory();
        }

        public File getBaseSourceDirectory() {
            return AbstractDocbookTask.this.directoryLayout.getMasterSourceDirectory();
        }

        public File getRootDocumentFile() {
            if (this.rootMasterFile == null) {
                this.rootMasterFile = new File(this.getBaseSourceDirectory(), AbstractDocbookTask.this.sourceDocumentName);
            }
            return this.rootMasterFile;
        }

        public Set<File> getDocumentFiles() {
            if (this.masterFiles == null) {
                File rootMasterFile = this.getRootDocumentFile();
                TreeSet<File> files = new TreeSet<File>();
                files.add(rootMasterFile);
                XIncludeHelper.findAllInclusionFiles((File)rootMasterFile, files);
                this.masterFiles = Collections.unmodifiableSet(files);
            }
            return this.masterFiles;
        }
    }
}

