/*
 * IronJacamar, a Java EE Connector Architecture implementation
 * Copyright 2011, Red Hat Inc, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.jca.test.deployers.spec.rars.ra16inoutijmultianno;

import java.util.logging.Logger;

import jakarta.resource.spi.Activation;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.ConfigProperty;
import jakarta.resource.spi.InvalidPropertyException;
import jakarta.resource.spi.ResourceAdapter;

/**
 * TestActivationSpec
 *
 * @version $Revision: $
 */
@Activation(messageListeners =
      {org.jboss.jca.test.deployers.spec.rars.ra16inoutijmultianno.
            TestMessageListener.class })
public class TestActivationSpec implements ActivationSpec
{

   /** The logger */
   private static Logger log = Logger.getLogger("TestActivationSpec");

   /** The resource adapter */
   private ResourceAdapter ra;

   /** charProperty */
   @ConfigProperty(defaultValue = "a")
   private Character charProperty;

   /**
    * Default constructor
    */
   public TestActivationSpec()
   {

   }

   /** 
    * Set charProperty
    * @param charProperty The value
    */
   public void setCharProperty(Character charProperty)
   {
      this.charProperty = charProperty;
   }

   /** 
    * Get charProperty
    * @return The value
    */
   public Character getCharProperty()
   {
      return charProperty;
   }

   /**
    * This method may be called by a deployment tool to validate the overall
    * activation configuration information provided by the endpoint deployer.
    *
    * @throws InvalidPropertyException indicates invalid onfiguration property settings.
    */
   public void validate() throws InvalidPropertyException
   {
      log.finest("validate()");
   }

   /**
    * Get the resource adapter
    *
    * @return The handle
    */
   public ResourceAdapter getResourceAdapter()
   {
      log.finest("getResourceAdapter()");
      return ra;
   }

   /**
    * Set the resource adapter
    *
    * @param ra The handle
    */
   public void setResourceAdapter(ResourceAdapter ra)
   {
      log.finest("setResourceAdapter()");
      this.ra = ra;
   }

}
