/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt;

import com.icl.saxon.Controller;
import com.icl.saxon.TransformerFactoryImpl;
import com.icl.saxon.output.Emitter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.jboss.jdocbook.Configuration;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.ResourceDelegate;
import org.jboss.jdocbook.util.NoOpWriter;
import org.jboss.jdocbook.xslt.AbstractCatalogManager;
import org.jboss.jdocbook.xslt.ClasspathResolver;
import org.jboss.jdocbook.xslt.ExplicitCatalogManager;
import org.jboss.jdocbook.xslt.FormatPlan;
import org.jboss.jdocbook.xslt.ImplicitCatalogManager;
import org.jboss.jdocbook.xslt.RelativeJarUriResolver;
import org.jboss.jdocbook.xslt.ResolverChain;
import org.jboss.jdocbook.xslt.TransformerBuilder;
import org.jboss.jdocbook.xslt.VersionResolver;
import org.jboss.jdocbook.xslt.XSLTException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class TransformerBuilderImpl
implements TransformerBuilder {
    private final JDocBookComponentRegistry componentRegistry;
    private final CatalogResolver catalogResolver;
    private HashMap<String, Templates> transformerTemplatesCache = new HashMap();

    public TransformerBuilderImpl(JDocBookComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
        AbstractCatalogManager catalogManager = componentRegistry.getConfiguration().getCatalogs() == null || componentRegistry.getConfiguration().getCatalogs().size() == 0 ? new ImplicitCatalogManager() : new ExplicitCatalogManager(componentRegistry.getConfiguration().getCatalogs());
        this.catalogResolver = new CatalogResolver((CatalogManager)catalogManager);
    }

    @Override
    public CatalogResolver getCatalogResolver() {
        return this.catalogResolver;
    }

    protected Environment environment() {
        return this.componentRegistry.getEnvironment();
    }

    protected ResourceDelegate resourceDelegate() {
        return this.environment().getResourceDelegate();
    }

    protected Configuration configuration() {
        return this.componentRegistry.getConfiguration();
    }

    @Override
    public Transformer buildStandardTransformer(URL xslt) {
        ResolverChain uriResolver = this.buildStandardUriResolver();
        return this.buildTransformer(xslt, uriResolver);
    }

    @Override
    public Transformer buildStandardTransformer(String xsltResource) {
        ResolverChain uriResolver = this.buildStandardUriResolver();
        return this.buildTransformer(this.resourceDelegate().requireResource(xsltResource), uriResolver);
    }

    private ResolverChain buildStandardUriResolver() {
        ResolverChain resolverChain = new ResolverChain();
        this.applyStandardResolvers(resolverChain);
        return resolverChain;
    }

    private void applyStandardResolvers(ResolverChain resolverChain) {
        resolverChain.addResolver(new VersionResolver(this.componentRegistry));
        resolverChain.addResolver(new RelativeJarUriResolver());
        resolverChain.addResolver(new ClasspathResolver(this.componentRegistry));
        resolverChain.addResolver((URIResolver)this.catalogResolver);
    }

    @Override
    public Transformer buildTransformer(FormatPlan formatPlan, URL customStylesheet) throws XSLTException {
        ResolverChain uriResolver = this.buildStandardUriResolver();
        URL xsltStylesheet = customStylesheet == null ? this.resourceDelegate().requireResource(formatPlan.getStylesheetResource()) : customStylesheet;
        return this.buildTransformer(xsltStylesheet, uriResolver);
    }

    protected Transformer buildTransformer(URL xslt, URIResolver uriResolver) throws XSLTException {
        Transformer transformer;
        SAXTransformerFactory transformerFactory = this.buildSAXTransformerFactory();
        transformerFactory.setURIResolver(uriResolver);
        String xsltUrlStr = xslt.toExternalForm();
        try {
            Templates transformerTemplates = this.transformerTemplatesCache.get(xsltUrlStr);
            if (transformerTemplates == null) {
                StreamSource source = new StreamSource(xslt.openStream(), xsltUrlStr);
                transformerTemplates = transformerFactory.newTemplates(source);
                this.transformerTemplatesCache.put(xsltUrlStr, transformerTemplates);
            }
            transformer = transformerTemplates.newTransformer();
        }
        catch (IOException e) {
            throw new XSLTException("problem opening stylesheet [" + xsltUrlStr + "]", e);
        }
        catch (TransformerConfigurationException e) {
            throw new XSLTException("unable to build transformer [" + e.getLocationAsString() + "] : " + e.getMessage(), e);
        }
        TransformerBuilderImpl.configureTransformer(transformer, uriResolver, this.configuration().getTransformerParameters());
        return transformer;
    }

    private SAXTransformerFactory buildSAXTransformerFactory() {
        TransformerFactoryImpl factoryImpl = new TransformerFactoryImpl();
        return factoryImpl;
    }

    private static void configureTransformer(Transformer transformer, URIResolver uriResolver, Map<String, String> transformerParameters) {
        if (transformer instanceof Controller) {
            Controller controller = (Controller)transformer;
            try {
                controller.makeMessageEmitter();
                controller.getMessageEmitter().setWriter((Writer)new NoOpWriter());
            }
            catch (TransformerException te) {
                // empty catch block
            }
        }
        transformer.setURIResolver(uriResolver);
        transformer.setParameter("fop.extensions", "0");
        transformer.setParameter("fop1.extensions", "1");
        if (transformerParameters == null) {
            return;
        }
        for (Map.Entry<String, String> entry : transformerParameters.entrySet()) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
    }

    private static class SaxonXslMessageEmitter
    extends Emitter {
        private static final Logger log = LoggerFactory.getLogger(SaxonXslMessageEmitter.class);
        private StringBuffer buffer;

        private SaxonXslMessageEmitter() {
        }

        public void startDocument() throws TransformerException {
            if (this.buffer != null) {
                System.out.println("Unexpected call sequence on SaxonXslMessageEmitter; discarding [" + this.buffer.toString() + "]");
            }
            this.buffer = new StringBuffer();
        }

        public void endDocument() throws TransformerException {
            log.trace("[STYLESHEET MESSAGE] " + this.buffer.toString());
            this.buffer.setLength(0);
            this.buffer = null;
        }

        public void startElement(int i, Attributes attributes, int[] ints, int i1) throws TransformerException {
        }

        public void endElement(int i) throws TransformerException {
        }

        public void characters(char[] chars, int start, int end) throws TransformerException {
            for (int i = start; i < end; ++i) {
                this.buffer.append(chars[i]);
            }
        }

        public void processingInstruction(String s, String s1) throws TransformerException {
        }

        public void comment(char[] chars, int i, int i1) throws TransformerException {
        }
    }
}

