/*
 * Decompiled with CFR 0.152.
 */
package net.socialchange.doctype;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.socialchange.doctype.Doctype;
import net.socialchange.doctype.DoctypeGenerator;
import net.socialchange.doctype.DoctypeParser;

public final class DoctypeChangerStream
extends FilterInputStream {
    protected Doctype doctype;
    protected DoctypeGenerator generator;
    protected boolean docStarted = false;
    protected boolean inComment = false;
    protected StringBuffer myBuffer = new StringBuffer();
    private boolean endOfStream = false;

    public DoctypeChangerStream(InputStream in) {
        super(in);
    }

    public void setGenerator(DoctypeGenerator generator) {
        this.generator = generator;
    }

    public Doctype getDoctype() {
        return this.doctype;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        int c = 32;
        if (this.myBuffer.length() != 0) return this.feedFromInternalBuffer();
        c = this.in.read();
        if (!this.docStarted && !this.inComment && c == 60) {
            int d = this.in.read();
            switch (d) {
                case 63: {
                    this.myBuffer.append((char)d);
                    return c;
                }
                case 33: {
                    int e = this.in.read();
                    if (e == 68) {
                        DoctypeParser parser = new DoctypeParser();
                        StringBuffer doctypeBuf = new StringBuffer(200);
                        doctypeBuf.append((char)d).append((char)e);
                        parser.parse(this.in, doctypeBuf);
                        this.doctype = this.generator == null ? parser.getDoctype() : this.generator.generate(parser.getDoctype());
                        if (this.doctype == null) {
                            doctypeBuf = null;
                            c = this.in.read();
                        } else if (this.doctype.equals(parser.getDoctype())) {
                            this.myBuffer.append(doctypeBuf.toString());
                        } else if (this.doctype != null) {
                            doctypeBuf = null;
                            this.addDocType();
                        }
                        this.docStarted = true;
                        return c;
                    }
                    if (e == 45) {
                        int f = this.in.read();
                        if (f != 45) return c;
                        this.inComment = true;
                        this.myBuffer.append((char)d);
                        this.myBuffer.append((char)e);
                        this.myBuffer.append((char)f);
                        return c;
                    }
                    this.myBuffer.append((char)d);
                    this.myBuffer.append((char)e);
                    return c;
                }
                default: {
                    if (this.generator != null) {
                        this.doctype = this.generator.generate(null);
                    }
                    if (this.doctype != null) {
                        this.addDocType();
                        this.myBuffer.append('<');
                    }
                    this.myBuffer.append((char)d);
                    this.docStarted = true;
                }
            }
            return c;
        } else {
            if (!this.inComment) return c;
            if (c != 45) return c;
            int d = this.in.read();
            if (d == 45) {
                int e = this.in.read();
                if (e == 62) {
                    this.inComment = false;
                }
                this.myBuffer.append((char)d);
                this.myBuffer.append((char)e);
                return c;
            } else {
                this.myBuffer.append((char)d);
            }
        }
        return c;
    }

    public int read(byte[] text, int offset, int length) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int numRead = 0;
        for (int i = offset; i < offset + length; ++i) {
            int temp = this.read();
            if (temp == -1) {
                this.endOfStream = true;
                break;
            }
            text[i] = (byte)temp;
            ++numRead;
        }
        return numRead;
    }

    private void addQuotedStr(String str) {
        char quote = str.indexOf("'") == -1 ? (char)'\'' : '\"';
        this.myBuffer.append(quote);
        this.myBuffer.append(str);
        this.myBuffer.append(quote);
    }

    protected void addDocType() {
        String eol;
        try {
            eol = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            eol = "\n";
        }
        String root = this.doctype.getRootElement();
        String sysId = this.doctype.getSystemId();
        String pubId = this.doctype.getPublicId();
        String intSubset = this.doctype.getInternalSubset();
        this.myBuffer.append("!DOCTYPE ");
        this.myBuffer.append(root);
        if (pubId == null) {
            if (sysId != null) {
                this.myBuffer.append(" SYSTEM ");
                this.addQuotedStr(sysId);
            }
        } else {
            this.myBuffer.append(" PUBLIC ");
            this.addQuotedStr(pubId);
            this.myBuffer.append(" ");
            this.addQuotedStr(sysId);
        }
        this.myBuffer.append(" ");
        if (intSubset != null) {
            this.myBuffer.append("[" + eol);
            this.myBuffer.append(intSubset);
            this.myBuffer.append(eol + "]");
        }
        this.myBuffer.append(">" + eol);
        this.docStarted = true;
    }

    protected int feedFromInternalBuffer() {
        char retChar = this.myBuffer.charAt(0);
        this.myBuffer.reverse();
        this.myBuffer.setLength(this.myBuffer.length() - 1);
        this.myBuffer.reverse();
        return retChar;
    }
}

