/*
 * IronJacamar, a Java EE Connector Architecture implementation
 * Copyright 2008-2009, Red Hat Inc, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.jca.core.connectionmanager.common;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

/**
 * Mock XAResource.
 * @author <a href="mailto:gurkanerdogdu@yahoo.com">Gurkan Erdogdu</a> 
 * @version $Rev$ $Date$
 *
 */
public class MockXAResource implements XAResource
{
   /**
    * {@inheritDoc}
    */
   public void commit(Xid xid, boolean onePhase) throws XAException
   {
      
      
   }

   /**
    * {@inheritDoc}
    */
   public void end(Xid xid, int flags) throws XAException
   {
      
      
   }

   /**
    * {@inheritDoc}
    */   
   public void forget(Xid xid) throws XAException
   {
      
      
   }

   /**
    * {@inheritDoc}
    */   
   public int getTransactionTimeout() throws XAException
   {
      
      return 0;
   }

   /**
    * {@inheritDoc}
    */   
   public boolean isSameRM(XAResource xares) throws XAException
   {
      
      return false;
   }

   /**
    * {@inheritDoc}
    */   
   public int prepare(Xid xid) throws XAException
   {
      
      return 0;
   }

   /**
    * {@inheritDoc}
    */   
   public Xid[] recover(int flag) throws XAException
   {
      
      return new Xid[0];
   }

   /**
    * {@inheritDoc}
    */   
   public void rollback(Xid xid) throws XAException
   {
      
      
   }

   /**
    * {@inheritDoc}
    */   
   public boolean setTransactionTimeout(int seconds) throws XAException
   {
      
      return false;
   }

   /**
    * {@inheritDoc}
    */   
   public void start(Xid xid, int flags) throws XAException
   {
      
      
   }

}
