/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.test.eis.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.jca.test.eis.impl.HandlerSocket;

public class HandlerServer
implements Runnable {
    private String bindAddress;
    private int bindPort;
    private Class handler;
    private AtomicBoolean running;
    private ServerSocket ss;
    private ExecutorService executorService;
    private Set<HandlerSocket> active;

    public HandlerServer(String bindAddress, int bindPort, Class handler) throws IOException {
        this.bindAddress = bindAddress;
        this.bindPort = bindPort;
        this.handler = handler;
        this.running = new AtomicBoolean(false);
        this.ss = null;
        this.executorService = null;
        this.active = Collections.synchronizedSet(new HashSet());
    }

    public void start() throws Throwable {
        if (!this.running.get()) {
            InetSocketAddress address = new InetSocketAddress(this.bindAddress, this.bindPort);
            this.ss = new ServerSocket();
            this.ss.bind(address);
            this.executorService = Executors.newCachedThreadPool();
            this.running.set(true);
            this.executorService.submit(this);
        }
    }

    public void stop() throws Throwable {
        this.running.set(false);
        for (HandlerSocket hs : this.active) {
            hs.shutdown();
        }
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.ss = null;
        }
        if (this.executorService != null) {
            try {
                this.executorService.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.executorService = null;
        }
    }

    @Override
    public void run() {
        while (this.running.get()) {
            try {
                Socket socket = this.ss.accept();
                HandlerSocket hs = new HandlerSocket(this.handler, socket, this);
                this.active.add(hs);
                this.executorService.submit(hs);
            }
            catch (Exception e) {
                if (!this.running.get()) continue;
                e.printStackTrace(System.err);
            }
        }
    }

    void done(HandlerSocket hs) {
        this.active.remove(hs);
    }
}

