/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.test.eis.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import org.jboss.jca.test.eis.Handler;
import org.jboss.jca.test.eis.impl.HandlerServer;

public class HandlerSocket
implements Runnable {
    private Class handler;
    private Socket socket;
    private HandlerServer server;

    public HandlerSocket(Class handler, Socket socket, HandlerServer server) {
        this.handler = handler;
        this.socket = socket;
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.handler.getClassLoader());
            InputStream is = this.socket.getInputStream();
            OutputStream os = this.socket.getOutputStream();
            Handler instance = this.createHandler();
            instance.handle(is, os);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            this.shutdown();
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    void shutdown() {
        this.server.done(this);
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Handler createHandler() throws Throwable {
        for (Class clz = this.handler; clz != Object.class; clz = clz.getSuperclass()) {
            try {
                Constructor c = clz.getDeclaredConstructor(null);
                c.setAccessible(true);
                return (Handler)c.newInstance(null);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                continue;
            }
        }
        throw new IllegalStateException("Unable to find default constructor");
    }
}

