/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import org.jboss.logging.annotations.Message;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.validation.AbstractFormatValidator;
import org.jboss.logging.processor.validation.FormatValidator;
import org.jboss.logging.processor.validation.MessageFormatValidator;
import org.jboss.logging.processor.validation.NoFormatValidator;
import org.jboss.logging.processor.validation.StringFormatValidator;

public final class FormatValidatorFactory {
    private FormatValidatorFactory() {
    }

    public static FormatValidator create(MessageMethod messageMethod) throws IllegalStateException {
        if (messageMethod.message() == null) {
            return InvalidFormatValidator.of("No message annotation found.");
        }
        return FormatValidatorFactory.create(messageMethod.message().format(), messageMethod.message().value());
    }

    public static FormatValidator create(Message.Format format, String message) throws IllegalStateException {
        if (message == null) {
            return InvalidFormatValidator.of("A message is required for the format.");
        }
        if (format == null) {
            return InvalidFormatValidator.of("A format is required for the message.");
        }
        switch (format) {
            case MESSAGE_FORMAT: {
                return MessageFormatValidator.of(message);
            }
            case PRINTF: {
                return StringFormatValidator.of(message);
            }
            case NO_FORMAT: {
                return NoFormatValidator.INSTANCE;
            }
        }
        return InvalidFormatValidator.of(String.format("Format %s is invalid.", new Object[]{format}));
    }

    private static final class InvalidFormatValidator
    extends AbstractFormatValidator {
        private InvalidFormatValidator() {
        }

        static FormatValidator of(String summaryMessage) {
            InvalidFormatValidator result = new InvalidFormatValidator();
            result.setSummaryMessage(summaryMessage);
            return result;
        }

        static FormatValidator of(String summaryMessage, String detailMessage) {
            InvalidFormatValidator result = new InvalidFormatValidator();
            result.setDetailMessage(detailMessage);
            result.setSummaryMessage(summaryMessage);
            return result;
        }

        @Override
        public String format() {
            return "";
        }

        @Override
        public int argumentCount() {
            return 0;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }
}

