/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.DataSourceAbstractImpl;

public class XADataSourceImpl
extends DataSourceAbstractImpl
implements XaDataSource {
    private static final long serialVersionUID = 1L;
    protected HashMap<String, String> xaDataSourceProperty;
    protected String xaDataSourceClass;
    protected DsXaPool xaPool;
    protected Recovery recovery;
    protected String urlProperty;

    public XADataSourceImpl(TransactionIsolation transactionIsolation, TimeOut timeOut, DsSecurity security, Statement statement, Validation validation, String urlDelimiter, String urlProperty, String urlSelectorStrategyClassName, Boolean useJavaContext, String poolName, Boolean enabled, String jndiName, Boolean spy, Boolean useCcm, Boolean connectable, Boolean tracking, String mcp, Boolean enlistmentTrace, Map<String, String> xaDataSourceProperty, String xaDataSourceClass, String driver, String newConnectionSql, DsXaPool xaPool, Recovery recovery) throws ValidateException {
        super(transactionIsolation, timeOut, security, statement, validation, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm, driver, newConnectionSql, connectable, tracking, mcp, enlistmentTrace);
        if (xaDataSourceProperty != null) {
            this.xaDataSourceProperty = new HashMap(xaDataSourceProperty.size());
            this.xaDataSourceProperty.putAll(xaDataSourceProperty);
        } else {
            this.xaDataSourceProperty = new HashMap(0);
        }
        this.xaDataSourceClass = xaDataSourceClass;
        this.xaPool = xaPool;
        this.recovery = recovery;
        this.urlProperty = urlProperty;
        this.validate();
    }

    @Override
    public String getXaDataSourceClass() {
        return this.xaDataSourceClass;
    }

    @Override
    public Map<String, String> getXaDataSourceProperty() {
        return Collections.unmodifiableMap(this.xaDataSourceProperty);
    }

    @Override
    public DsXaPool getXaPool() {
        return this.xaPool;
    }

    @Override
    public String getUrlProperty() {
        return this.urlProperty;
    }

    @Override
    public Recovery getRecovery() {
        return this.recovery;
    }

    public void forceXaDataSourceClass(String xaDataSourceClass) {
        this.xaDataSourceClass = xaDataSourceClass;
    }

    @Override
    public void validate() throws ValidateException {
        if (!(this.xaDataSourceClass != null && this.xaDataSourceClass.trim().length() != 0 || this.driver != null && this.driver.trim().length() != 0)) {
            throw new ValidateException(bundle.requiredElementMissing(XaDataSource.Tag.XA_DATASOURCE_CLASS.getLocalName(), this.getClass().getCanonicalName()));
        }
        if (this.xaDataSourceProperty.isEmpty()) {
            throw new ValidateException(bundle.requiredElementMissing(XaDataSource.Tag.XA_DATASOURCE_PROPERTY.getLocalName(), this.getClass().getCanonicalName()));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.xaDataSourceClass == null ? 0 : this.xaDataSourceClass.hashCode());
        result = 31 * result + (this.xaDataSourceProperty == null ? 0 : this.xaDataSourceProperty.hashCode());
        result = 31 * result + (this.xaPool == null ? 0 : this.xaPool.hashCode());
        result = 31 * result + (this.urlProperty == null ? 0 : this.urlProperty.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof XADataSourceImpl)) {
            return false;
        }
        XADataSourceImpl other = (XADataSourceImpl)obj;
        if (this.xaDataSourceClass == null ? other.xaDataSourceClass != null : !this.xaDataSourceClass.equals(other.xaDataSourceClass)) {
            return false;
        }
        if (this.xaDataSourceProperty == null ? other.xaDataSourceProperty != null : !this.xaDataSourceProperty.equals(other.xaDataSourceProperty)) {
            return false;
        }
        if (this.xaPool == null ? other.xaPool != null : !this.xaPool.equals(other.xaPool)) {
            return false;
        }
        return !(this.urlProperty == null ? other.urlProperty != null : !this.urlProperty.equals(other.urlProperty));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xa-datasource");
        if (this.jndiName != null) {
            sb.append(" ").append((Object)XaDataSource.Attribute.JNDI_NAME).append("=\"").append(this.jndiName).append("\"");
        }
        if (this.poolName != null) {
            sb.append(" ").append((Object)XaDataSource.Attribute.POOL_NAME).append("=\"").append(this.poolName).append("\"");
        }
        if (this.enabled != null) {
            sb.append(" ").append((Object)XaDataSource.Attribute.ENABLED).append("=\"").append(this.enabled).append("\"");
        }
        if (this.useJavaContext != null) {
            sb.append(" ").append((Object)XaDataSource.Attribute.USE_JAVA_CONTEXT);
            sb.append("=\"").append(this.useJavaContext).append("\"");
        }
        if (this.spy != null) {
            sb.append(" ").append((Object)XaDataSource.Attribute.SPY).append("=\"").append(this.spy).append("\"");
        }
        if (this.useCcm != null) {
            sb.append(" ").append((Object)XaDataSource.Attribute.USE_CCM).append("=\"").append(this.useCcm).append("\"");
        }
        if (this.connectable != null) {
            sb.append(" ").append((Object)XaDataSource.Attribute.CONNECTABLE).append("=\"").append(this.connectable).append("\"");
        }
        if (this.tracking != null) {
            sb.append(" ").append((Object)XaDataSource.Attribute.TRACKING).append("=\"").append(this.tracking).append("\"");
        }
        if (this.mcp != null) {
            sb.append(" ").append((Object)XaDataSource.Attribute.MCP).append("=\"").append(this.mcp).append("\"");
        }
        if (this.enlistmentTrace != null) {
            sb.append(" ").append((Object)XaDataSource.Attribute.ENLISTMENT_TRACE).append("=\"").append(this.enlistmentTrace).append("\"");
        }
        sb.append(">");
        if (this.xaDataSourceProperty != null && this.xaDataSourceProperty.size() > 0) {
            for (Map.Entry<String, String> entry : this.xaDataSourceProperty.entrySet()) {
                sb.append("<").append((Object)XaDataSource.Tag.XA_DATASOURCE_PROPERTY);
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append((Object)XaDataSource.Tag.XA_DATASOURCE_PROPERTY).append(">");
            }
        }
        if (this.xaDataSourceClass != null) {
            sb.append("<").append((Object)XaDataSource.Tag.XA_DATASOURCE_CLASS).append(">");
            sb.append(this.xaDataSourceClass);
            sb.append("</").append((Object)XaDataSource.Tag.XA_DATASOURCE_CLASS).append(">");
        }
        if (this.driver != null) {
            sb.append("<").append((Object)XaDataSource.Tag.DRIVER).append(">");
            sb.append(this.driver);
            sb.append("</").append((Object)XaDataSource.Tag.DRIVER).append(">");
        }
        if (this.urlDelimiter != null) {
            sb.append("<").append((Object)XaDataSource.Tag.URL_DELIMITER).append(">");
            sb.append(this.urlDelimiter);
            sb.append("</").append((Object)XaDataSource.Tag.URL_DELIMITER).append(">");
        }
        if (this.urlProperty != null) {
            sb.append("<").append((Object)XaDataSource.Tag.URL_PROPERTY).append(">");
            sb.append(this.urlProperty);
            sb.append("</").append((Object)XaDataSource.Tag.URL_PROPERTY).append(">");
        }
        if (this.urlSelectorStrategyClassName != null) {
            sb.append("<").append((Object)XaDataSource.Tag.URL_SELECTOR_STRATEGY_CLASS_NAME).append(">");
            sb.append(this.urlSelectorStrategyClassName);
            sb.append("</").append((Object)XaDataSource.Tag.URL_SELECTOR_STRATEGY_CLASS_NAME).append(">");
        }
        if (this.newConnectionSql != null) {
            sb.append("<").append((Object)XaDataSource.Tag.NEW_CONNECTION_SQL).append(">");
            sb.append(this.newConnectionSql);
            sb.append("</").append((Object)XaDataSource.Tag.NEW_CONNECTION_SQL).append(">");
        }
        if (this.transactionIsolation != null) {
            sb.append("<").append((Object)XaDataSource.Tag.TRANSACTION_ISOLATION).append(">");
            sb.append(this.transactionIsolation);
            sb.append("</").append((Object)XaDataSource.Tag.TRANSACTION_ISOLATION).append(">");
        }
        if (this.xaPool != null) {
            sb.append(this.xaPool);
        }
        if (this.security != null) {
            sb.append(this.security);
        }
        if (this.validation != null) {
            sb.append(this.validation);
        }
        if (this.timeOut != null) {
            sb.append(this.timeOut);
        }
        if (this.statement != null) {
            sb.append(this.statement);
        }
        if (this.recovery != null) {
            sb.append(this.recovery);
        }
        sb.append("</xa-datasource>");
        return sb.toString();
    }
}

