/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Fail;
import org.fest.assertions.GenericAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComparableAssert<S, T extends Comparable<T>>
extends GenericAssert<S, T> {
    protected ComparableAssert(Class<S> selfType, T actual) {
        super(selfType, actual);
    }

    public final S isEqualByComparingTo(T expected) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(expected) == 0) {
            return (S)this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw Fail.comparisonFailed(this.rawDescription(), this.actual, expected);
    }

    public final S isNotEqualByComparingTo(T expected) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(expected) != 0) {
            return (S)this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, expected));
    }

    public final S isLessThan(T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) < 0) {
            return (S)this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public final S isGreaterThan(T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) > 0) {
            return (S)this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public final S isLessThanOrEqualTo(T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) <= 0) {
            return (S)this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    public final S isGreaterThanOrEqualTo(T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) >= 0) {
            return (S)this.myself;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }
}

