/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.DOMExceptionImpl;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class TextOverNodeInfo
extends NodeOverNodeInfo
implements Text,
Comment {
    public String getData() {
        return this.node.getStringValue();
    }

    public void setData(String string) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    public int getLength() {
        return this.node.getStringValue().length();
    }

    public String substringData(int n, int n2) throws DOMException {
        try {
            return this.node.getStringValue().substring(n, n + n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, "substringData: index out of bounds");
        }
    }

    public void appendData(String string) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    public void insertData(int n, String string) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    public void deleteData(int n, int n2) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
    }

    public Text splitText(int n) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
        return null;
    }

    public Text replaceWholeText(String string) throws DOMException {
        TextOverNodeInfo.disallowUpdate();
        return null;
    }

    public boolean isElementContentWhitespace() {
        if (this.node.getNodeKind() != 3) {
            throw new UnsupportedOperationException("Method is defined only on text nodes");
        }
        int n = this.node.getParent().getTypeAnnotation();
        if (n == -1) {
            return false;
        }
        if (!Whitespace.isWhite(this.node.getStringValue())) {
            return false;
        }
        SchemaType schemaType = this.node.getConfiguration().getSchemaType(n);
        if (!schemaType.isComplexType()) {
            return false;
        }
        return !((ComplexType)schemaType).isMixedContent();
    }

    public String getWholeText() {
        if (this.node.getNodeKind() != 3) {
            throw new UnsupportedOperationException("Method is defined only on text nodes");
        }
        return this.node.getStringValue();
    }
}

