/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.base.spec.se.manifest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImportException;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.jboss.shrinkwrap.descriptor.impl.base.spec.se.manifest.ManifestDescriptorImpl;
import org.jboss.shrinkwrap.descriptor.impl.base.spec.se.manifest.ManifestModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestDescriptorImporter
implements DescriptorImporter<ManifestDescriptor> {
    private final String descriptorName;

    public ManifestDescriptorImporter(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    @Override
    public ManifestDescriptor fromFile(File file) throws IllegalArgumentException, DescriptorImportException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        try {
            return new ManifestDescriptorImpl(this.descriptorName, new ManifestModel(file));
        }
        catch (Exception e) {
            throw new DescriptorImportException(e.getMessage(), e);
        }
    }

    @Override
    public ManifestDescriptor fromStream(InputStream in) throws IllegalArgumentException, DescriptorImportException {
        return this.fromStream(in, true);
    }

    @Override
    public ManifestDescriptor fromStream(InputStream in, boolean close) throws IllegalArgumentException, DescriptorImportException {
        if (in == null) {
            throw new IllegalArgumentException("Stream cannot be null");
        }
        try {
            ManifestDescriptorImpl manifestDescriptorImpl = new ManifestDescriptorImpl(this.descriptorName, new ManifestModel(in));
            return manifestDescriptorImpl;
        }
        catch (Exception e) {
            throw new DescriptorImportException(e.getMessage(), e);
        }
        finally {
            if (close) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new DescriptorImportException("Input stream not closed", e);
                }
            }
        }
    }

    @Override
    @Deprecated
    public ManifestDescriptor from(String manifest) throws IllegalArgumentException, DescriptorImportException {
        return this.fromString(manifest);
    }

    @Override
    public ManifestDescriptor fromString(String manifest) throws IllegalArgumentException, DescriptorImportException {
        if (manifest == null) {
            throw new IllegalArgumentException("Manifest cannot be null");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(manifest.getBytes());
        try {
            return new ManifestDescriptorImpl(this.descriptorName, new ManifestModel(inputStream));
        }
        catch (IOException e) {
            throw new DescriptorImportException(e.getMessage(), e);
        }
    }

    @Override
    public ManifestDescriptor from(File file) throws IllegalArgumentException, DescriptorImportException {
        return this.fromFile(file);
    }

    @Override
    public ManifestDescriptor fromFile(String file) throws IllegalArgumentException, DescriptorImportException {
        return this.fromFile(new File(file));
    }

    @Override
    public ManifestDescriptor from(InputStream in) throws IllegalArgumentException, DescriptorImportException {
        return this.fromStream(in);
    }

    @Override
    public ManifestDescriptor from(InputStream in, boolean close) throws IllegalArgumentException, DescriptorImportException {
        return this.fromStream(in, close);
    }
}

