/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.resourceadapter;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.Activations;
import org.jboss.jca.common.api.metadata.resourceadapter.AdminObject;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManager;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.CommonIronJacamarParser;
import org.jboss.jca.common.metadata.resourceadapter.ActivationImpl;
import org.jboss.jca.common.metadata.resourceadapter.ActivationsImpl;
import org.jboss.logging.Messages;

public class ResourceAdapterParser
extends CommonIronJacamarParser
implements MetadataParser<Activations> {
    private static CommonBundle bundle = Messages.getBundle(CommonBundle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Activations parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        Object adapters = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        try {
            Activations activations = this.parse(reader);
            return activations;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public Activations parse(XMLStreamReader reader) throws Exception {
        int iterate;
        Activations adapters = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case RESOURCE_ADAPTERS: {
                        adapters = this.parseResourceAdapters(reader);
                        break block1;
                    }
                }
                throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return adapters;
    }

    private Activations parseResourceAdapters(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<Activation> resourceAdapters = new ArrayList<Activation>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.RESOURCE_ADAPTERS) {
                        resourceAdapters.trimToSize();
                        return new ActivationsImpl(resourceAdapters);
                    }
                    if (Activations.Tag.forName(reader.getLocalName()) != Activations.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Activations.Tag.forName(reader.getLocalName())) {
                        case RESOURCE_ADAPTER: {
                            resourceAdapters.add(this.parseResourceAdapter(reader));
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    private Activation parseResourceAdapter(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        ArrayList<ConnectionDefinition> connectionDefinitions = null;
        ArrayList<AdminObject> adminObjects = null;
        ArrayList<String> beanValidationGroups = null;
        String bootstrapContext = null;
        String id = null;
        String archive = null;
        TransactionSupportEnum transactionSupport = null;
        HashMap<String, String> configProperties = null;
        WorkManager workmanager = null;
        Boolean isXA = null;
        int attributeSize = reader.getAttributeCount();
        block18: for (int i = 0; i < attributeSize; ++i) {
            Activation.Attribute attribute = Activation.Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    id = this.attributeAsString(reader, attribute.getLocalName());
                    continue block18;
                }
                default: {
                    throw new ParserException(bundle.unexpectedAttribute(attribute.getLocalName(), reader.getLocalName()));
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (Activations.Tag.forName(reader.getLocalName()) == Activations.Tag.RESOURCE_ADAPTER) {
                        return new ActivationImpl(id, archive, transactionSupport, connectionDefinitions, adminObjects, configProperties, beanValidationGroups, bootstrapContext, workmanager);
                    }
                    if (Activation.Tag.forName(reader.getLocalName()) != Activation.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Activation.Tag.forName(reader.getLocalName())) {
                        case ADMIN_OBJECTS: 
                        case CONNECTION_DEFINITIONS: 
                        case BEAN_VALIDATION_GROUPS: {
                            break block3;
                        }
                        case ADMIN_OBJECT: {
                            if (adminObjects == null) {
                                adminObjects = new ArrayList<AdminObject>();
                            }
                            adminObjects.add(this.parseAdminObjects(reader));
                            break block3;
                        }
                        case CONNECTION_DEFINITION: {
                            if (connectionDefinitions == null) {
                                connectionDefinitions = new ArrayList<ConnectionDefinition>();
                            }
                            connectionDefinitions.add(this.parseConnectionDefinitions(reader, isXA));
                            break block3;
                        }
                        case BEAN_VALIDATION_GROUP: {
                            if (beanValidationGroups == null) {
                                beanValidationGroups = new ArrayList<String>();
                            }
                            beanValidationGroups.add(this.elementAsString(reader));
                            break block3;
                        }
                        case BOOTSTRAP_CONTEXT: {
                            bootstrapContext = this.elementAsString(reader);
                            break block3;
                        }
                        case CONFIG_PROPERTY: {
                            if (configProperties == null) {
                                configProperties = new HashMap<String, String>();
                            }
                            this.parseConfigProperty(configProperties, reader);
                            break block3;
                        }
                        case TRANSACTION_SUPPORT: {
                            transactionSupport = TransactionSupportEnum.valueOf(this.elementAsString(reader));
                            if (transactionSupport != TransactionSupportEnum.XATransaction) break block3;
                            isXA = Boolean.TRUE;
                            break block3;
                        }
                        case ARCHIVE: {
                            archive = this.elementAsString(reader);
                            break block3;
                        }
                        case WORKMANAGER: {
                            workmanager = this.parseWorkManager(reader);
                            break block3;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        RESOURCE_ADAPTERS("resource-adapters");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

