/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.resourceadapter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManagerSecurity;

public class WorkManagerSecurityImpl
implements WorkManagerSecurity {
    private static final long serialVersionUID = 1L;
    private boolean mappingRequired;
    private String domain;
    private String defaultPrincipal;
    private List<String> defaultGroups;
    private Map<String, String> userMappings;
    private Map<String, String> groupMappings;

    public WorkManagerSecurityImpl(boolean mappingRequired, String domain, String defaultPrincipal, List<String> defaultGroups, Map<String, String> userMappings, Map<String, String> groupMappings) {
        this.mappingRequired = mappingRequired;
        this.domain = domain;
        this.defaultPrincipal = defaultPrincipal;
        this.defaultGroups = defaultGroups;
        this.userMappings = userMappings;
        this.groupMappings = groupMappings;
    }

    @Override
    public boolean isMappingRequired() {
        return this.mappingRequired;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getDefaultPrincipal() {
        return this.defaultPrincipal;
    }

    @Override
    public List<String> getDefaultGroups() {
        return this.defaultGroups != null ? Collections.unmodifiableList(this.defaultGroups) : null;
    }

    @Override
    public Map<String, String> getUserMappings() {
        return this.userMappings != null ? Collections.unmodifiableMap(this.userMappings) : null;
    }

    @Override
    public Map<String, String> getGroupMappings() {
        return this.groupMappings != null ? Collections.unmodifiableMap(this.groupMappings) : null;
    }

    public int hashCode() {
        int result = 31;
        result += this.mappingRequired ? 7 : 0;
        result += this.domain != null ? 7 * this.domain.hashCode() : 7;
        result += this.defaultPrincipal != null ? 7 * this.defaultPrincipal.hashCode() : 7;
        result += this.defaultGroups != null ? 7 * this.defaultGroups.hashCode() : 7;
        result += this.userMappings != null ? 7 * this.userMappings.hashCode() : 7;
        return result += this.groupMappings != null ? 7 * this.groupMappings.hashCode() : 7;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof WorkManagerSecurityImpl)) {
            return false;
        }
        WorkManagerSecurityImpl other = (WorkManagerSecurityImpl)o;
        if (this.mappingRequired != other.mappingRequired) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(other.domain) : other.domain != null) {
            return false;
        }
        if (this.defaultPrincipal != null ? !this.defaultPrincipal.equals(other.defaultPrincipal) : other.defaultPrincipal != null) {
            return false;
        }
        if (this.defaultGroups != null ? !this.defaultGroups.equals(other.defaultGroups) : other.defaultGroups != null) {
            return false;
        }
        if (this.userMappings != null ? !this.userMappings.equals(other.userMappings) : other.userMappings != null) {
            return false;
        }
        return !(this.groupMappings != null ? !this.groupMappings.equals(other.groupMappings) : other.groupMappings != null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<security>");
        sb.append("<").append((Object)WorkManagerSecurity.Tag.MAPPING_REQUIRED).append(">");
        sb.append(this.mappingRequired);
        sb.append("</").append((Object)WorkManagerSecurity.Tag.MAPPING_REQUIRED).append(">");
        sb.append("<").append((Object)WorkManagerSecurity.Tag.DOMAIN).append(">");
        sb.append(this.domain);
        sb.append("</").append((Object)WorkManagerSecurity.Tag.DOMAIN).append(">");
        if (this.defaultPrincipal != null) {
            sb.append("<").append((Object)WorkManagerSecurity.Tag.DEFAULT_PRINCIPAL).append(">");
            sb.append(this.defaultPrincipal);
            sb.append("</").append((Object)WorkManagerSecurity.Tag.DEFAULT_PRINCIPAL).append(">");
        }
        if (this.defaultGroups != null && this.defaultGroups.size() > 0) {
            sb.append("<").append((Object)WorkManagerSecurity.Tag.DEFAULT_GROUPS).append(">");
            for (String string : this.defaultGroups) {
                sb.append("<").append((Object)WorkManagerSecurity.Tag.GROUP).append(">");
                sb.append(string);
                sb.append("</").append((Object)WorkManagerSecurity.Tag.GROUP).append(">");
            }
            sb.append("</").append((Object)WorkManagerSecurity.Tag.DEFAULT_GROUPS).append(">");
        }
        if (this.userMappings != null && this.userMappings.size() > 0 || this.groupMappings != null && this.groupMappings.size() > 0) {
            sb.append("<").append((Object)WorkManagerSecurity.Tag.MAPPINGS).append(">");
            if (this.userMappings != null && this.userMappings.size() > 0) {
                sb.append("<").append((Object)WorkManagerSecurity.Tag.USERS).append(">");
                for (Map.Entry entry : this.userMappings.entrySet()) {
                    sb.append("<").append((Object)WorkManagerSecurity.Tag.MAP);
                    sb.append(" ").append((Object)WorkManagerSecurity.Attribute.FROM).append("=\"");
                    sb.append((String)entry.getKey()).append("\"");
                    sb.append(" ").append((Object)WorkManagerSecurity.Attribute.TO).append("=\"");
                    sb.append((String)entry.getValue()).append("\"");
                    sb.append("/>");
                }
                sb.append("</").append((Object)WorkManagerSecurity.Tag.USERS).append(">");
            }
            if (this.groupMappings != null && this.groupMappings.size() > 0) {
                sb.append("<").append((Object)WorkManagerSecurity.Tag.GROUPS).append(">");
                for (Map.Entry entry : this.groupMappings.entrySet()) {
                    sb.append("<").append((Object)WorkManagerSecurity.Tag.MAP);
                    sb.append(" ").append((Object)WorkManagerSecurity.Attribute.FROM).append("=\"");
                    sb.append((String)entry.getKey()).append("\"");
                    sb.append(" ").append((Object)WorkManagerSecurity.Attribute.TO).append("=\"");
                    sb.append((String)entry.getValue()).append("\"");
                    sb.append("/>");
                }
                sb.append("</").append((Object)WorkManagerSecurity.Tag.GROUPS).append(">");
            }
            sb.append("</").append((Object)WorkManagerSecurity.Tag.MAPPINGS).append(">");
        }
        sb.append("</security>");
        return sb.toString();
    }
}

