/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.validator.rules.as;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.resource.spi.ActivationSpec;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.Rule;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.ValidateClass;

public class ASConfigProperties
implements Rule {
    private static final String SECTION = "20.7";
    private static final Set<Class> VALID_TYPES = new HashSet<Class>(9);

    @Override
    public List<Failure> validate(Validate v, ResourceBundle rb) {
        ValidateClass vo;
        if (v != null && Key.ACTIVATION_SPEC == v.getKey() && v.getClazz() != null && ActivationSpec.class.isAssignableFrom(v.getClazz()) && (vo = (ValidateClass)v).getConfigProperties() != null && vo.getConfigProperties().size() > 0) {
            Class<?> clz = vo.getClazz();
            ArrayList<Failure> failures = new ArrayList<Failure>(1);
            for (ConfigProperty configProperty : vo.getConfigProperties()) {
                try {
                    Method method;
                    String methodName = "get" + configProperty.getConfigPropertyName().getValue().substring(0, 1).toUpperCase(Locale.US);
                    if (configProperty.getConfigPropertyName().getValue().length() > 1) {
                        methodName = methodName + configProperty.getConfigPropertyName().getValue().substring(1);
                    }
                    if (VALID_TYPES.contains((method = clz.getMethod(methodName, null)).getReturnType())) continue;
                    StringBuilder sb = new StringBuilder("Class: " + vo.getClazz().getName());
                    sb = sb.append(" Property: " + configProperty.getConfigPropertyName().getValue());
                    sb = sb.append(" Type: " + method.getReturnType().getName());
                    Failure failure = new Failure(0, SECTION, rb.getString("as.ASConfigProperties"), sb.toString());
                    failures.add(failure);
                }
                catch (Throwable t) {
                    try {
                        Method method;
                        String methodName = "is" + configProperty.getConfigPropertyName().getValue().substring(0, 1).toUpperCase(Locale.US);
                        if (configProperty.getConfigPropertyName().getValue().length() > 1) {
                            methodName = methodName + configProperty.getConfigPropertyName().getValue().substring(1);
                        }
                        if (VALID_TYPES.contains((method = clz.getMethod(methodName, null)).getReturnType())) continue;
                        StringBuilder sb = new StringBuilder("Class: " + vo.getClazz().getName());
                        sb = sb.append(" Property: " + configProperty.getConfigPropertyName().getValue());
                        sb = sb.append(" Type: " + method.getReturnType().getName());
                        Failure failure = new Failure(0, SECTION, rb.getString("as.ASConfigProperties"), sb.toString());
                        failures.add(failure);
                    }
                    catch (Throwable it) {}
                }
            }
            if (failures.size() == 0) {
                return null;
            }
            return failures;
        }
        return null;
    }

    static {
        VALID_TYPES.add(Boolean.class);
        VALID_TYPES.add(Byte.class);
        VALID_TYPES.add(Character.class);
        VALID_TYPES.add(Double.class);
        VALID_TYPES.add(Float.class);
        VALID_TYPES.add(Integer.class);
        VALID_TYPES.add(Long.class);
        VALID_TYPES.add(Short.class);
        VALID_TYPES.add(String.class);
    }
}

