/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.web.console;

import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.jca.web.console.AttrResultInfo;
import org.jboss.jca.web.console.DomainData;
import org.jboss.jca.web.console.MBeanData;
import org.jboss.jca.web.console.OpResultInfo;
import org.jboss.jca.web.console.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.util.propertyeditor.PropertyEditors;

public class Server {
    private static Logger log = Logger.getLogger(Server.class);

    public static MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public static MBeanServer getMBeanServer(String domain) {
        try {
            ArrayList<MBeanServer> l = MBeanServerFactory.findMBeanServer(null);
            if (l != null) {
                for (MBeanServer ms : l) {
                    String[] domains = ms.getDomains();
                    if (domains == null) continue;
                    for (String d : domains) {
                        if (!domain.equals(d)) continue;
                        return ms;
                    }
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static Iterator getDomainData() throws JMException {
        MBeanServer server = Server.getMBeanServer();
        TreeMap<String, DomainData> domainData = new TreeMap<String, DomainData>();
        if (server != null) {
            Set<ObjectName> objectNames = server.queryNames(null, null);
            for (ObjectName name : objectNames) {
                MBeanInfo info = server.getMBeanInfo(name);
                String domainName = name.getDomain();
                MBeanData mbeanData = new MBeanData(name, info);
                DomainData data = (DomainData)domainData.get(domainName);
                if (data == null) {
                    data = new DomainData(domainName);
                    domainData.put(domainName, data);
                }
                data.addData(mbeanData);
            }
        }
        return domainData.values().iterator();
    }

    public static MBeanData getMBeanData(String name) throws JMException {
        MBeanServer server = Server.getMBeanServer();
        ObjectName objName = new ObjectName(name);
        MBeanInfo info = server.getMBeanInfo(objName);
        return new MBeanData(objName, info);
    }

    public static Object getMBeanAttributeObject(String name, String attrName) throws JMException {
        MBeanServer server = Server.getMBeanServer();
        ObjectName objName = new ObjectName(name);
        return server.getAttribute(objName, attrName);
    }

    public static String getMBeanAttribute(String name, String attrName) throws JMException {
        MBeanServer server = Server.getMBeanServer();
        ObjectName objName = new ObjectName(name);
        String value = null;
        try {
            Object attr = server.getAttribute(objName, attrName);
            if (attr != null) {
                value = attr.toString();
            }
        }
        catch (JMException e) {
            value = e.getMessage();
        }
        return value;
    }

    public static AttrResultInfo getMBeanAttributeResultInfo(String name, MBeanAttributeInfo attrInfo) throws JMException {
        ClassLoader loader = SecurityActions.getThreadContextClassLoader();
        MBeanServer server = Server.getMBeanServer();
        ObjectName objName = new ObjectName(name);
        String attrName = attrInfo.getName();
        String attrType = attrInfo.getType();
        Object value = null;
        Throwable throwable = null;
        if (attrInfo.isReadable()) {
            try {
                value = server.getAttribute(objName, attrName);
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        Class<?> typeClass = null;
        try {
            typeClass = Classes.getPrimitiveTypeForName((String)attrType);
            if (typeClass == null) {
                typeClass = loader.loadClass(attrType);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        PropertyEditor editor = null;
        if (typeClass != null) {
            editor = PropertyEditorManager.findEditor(typeClass);
        }
        return new AttrResultInfo(attrName, editor, value, throwable);
    }

    public static AttributeList setAttributes(String name, HashMap attributes) throws JMException {
        MBeanServer server = Server.getMBeanServer();
        ObjectName objName = new ObjectName(name);
        MBeanInfo info = server.getMBeanInfo(objName);
        MBeanAttributeInfo[] attributesInfo = info.getAttributes();
        AttributeList newAttributes = new AttributeList();
        for (int a = 0; a < attributesInfo.length; ++a) {
            MBeanAttributeInfo attrInfo = attributesInfo[a];
            String attrName = attrInfo.getName();
            if (!attributes.containsKey(attrName)) continue;
            String value = (String)attributes.get(attrName);
            if (value.equals("null") && server.getAttribute(objName, attrName) == null) {
                log.tracef("ignoring 'null' for %s", (Object)attrName);
                continue;
            }
            String attrType = attrInfo.getType();
            Attribute attr = null;
            try {
                Object realValue = PropertyEditors.convertValue((String)value, (String)attrType);
                attr = new Attribute(attrName, realValue);
            }
            catch (ClassNotFoundException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Failed to load class for attribute: " + attrType), (Throwable)e);
                }
                throw new ReflectionException(e, "Failed to load class for attribute: " + attrType);
            }
            catch (IntrospectionException e) {
                log.tracef("Skipped setting attribute: %s, cannot find PropertyEditor for type: %s", (Object)attrName, (Object)attrType);
                continue;
            }
            server.setAttribute(objName, attr);
            newAttributes.add(attr);
        }
        return newAttributes;
    }

    public static OpResultInfo invokeOp(String name, int index, String[] args) throws JMException {
        MBeanServer server = Server.getMBeanServer();
        ObjectName objName = new ObjectName(name);
        MBeanInfo info = server.getMBeanInfo(objName);
        MBeanOperationInfo[] opInfo = info.getOperations();
        MBeanOperationInfo op = opInfo[index];
        MBeanParameterInfo[] paramInfo = op.getSignature();
        String[] argTypes = new String[paramInfo.length];
        for (int p = 0; p < paramInfo.length; ++p) {
            argTypes[p] = paramInfo[p].getType();
        }
        return Server.invokeOpByName(name, op.getName(), argTypes, args);
    }

    public static OpResultInfo invokeOpByName(String name, String opName, String[] argTypes, String[] args) throws JMException {
        MBeanServer server = Server.getMBeanServer();
        ObjectName objName = new ObjectName(name);
        int length = argTypes != null ? argTypes.length : 0;
        Object[] typedArgs = new Object[length];
        for (int p = 0; p < typedArgs.length; ++p) {
            String arg = args[p];
            try {
                Object argValue;
                typedArgs[p] = argValue = PropertyEditors.convertValue((String)arg, (String)argTypes[p]);
                continue;
            }
            catch (ClassNotFoundException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Failed to load class for arg" + p), (Throwable)e);
                }
                throw new ReflectionException(e, "Failed to load class for arg" + p);
            }
            catch (IntrospectionException e) {
                if (!argTypes[p].equals("java.lang.Object")) {
                    throw new javax.management.IntrospectionException("Failed to find PropertyEditor for type: " + argTypes[p]);
                }
                typedArgs[p] = arg;
            }
        }
        Object opReturn = server.invoke(objName, opName, typedArgs, argTypes);
        return new OpResultInfo(opName, argTypes, args, opReturn);
    }
}

