/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.fungal;

import com.github.fungal.api.classloading.ClassLoaderFactory;
import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.DeployerPhases;
import com.github.fungal.spi.deployers.Deployment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.Activations;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.metadata.resourceadapter.ResourceAdapterParser;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.naming.JndiStrategy;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.deployers.fungal.AbstractFungalRADeployer;
import org.jboss.jca.deployers.fungal.RAConfiguration;
import org.jboss.jca.deployers.fungal.RaXmlDeployment;
import org.jboss.jca.deployers.fungal.SecurityActions;
import org.jboss.logging.Logger;

public final class RaXmlDeployer
extends AbstractFungalRADeployer
implements Deployer,
DeployerPhases {
    private static DeployersLogger log = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)RaXmlDeployer.class.getName());
    private List<Deployment> deployments;

    public RaXmlDeployer() {
        super(false);
    }

    protected DeployersLogger getLogger() {
        return log;
    }

    public boolean accepts(URL url) {
        return url != null && url.toExternalForm().endsWith("-ra.xml");
    }

    public int getOrder() {
        return 1;
    }

    public void preDeploy() throws Throwable {
    }

    public void postDeploy() throws Throwable {
    }

    public void preUndeploy() throws Throwable {
        if (this.deployments != null) {
            for (Deployment raDeployment : this.deployments) {
                try {
                    this.kernel.getMainDeployer().unregisterDeployment(raDeployment);
                }
                catch (Throwable t) {
                    log.warn((Object)("Error during undeployment of " + raDeployment.getURL()));
                }
            }
            this.deployments = null;
        }
    }

    public void postUndeploy() throws Throwable {
    }

    public synchronized Deployment deploy(URL url, Context context, ClassLoader parent) throws com.github.fungal.spi.deployers.DeployException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deploying: " + url.toExternalForm()));
        }
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        InputStream is = null;
        try {
            File f = new File(url.toURI());
            if (!f.exists()) {
                throw new IOException("Archive " + url.toExternalForm() + " doesnt exists");
            }
            ResourceAdapterParser parser = new ResourceAdapterParser();
            is = new FileInputStream(f);
            Activations raXmlDeployment = parser.parse(is);
            int size = raXmlDeployment.getActivations().size();
            if (size == 1) {
                Deployment deployment = this.doDeploy(url, (Activation)raXmlDeployment.getActivations().get(0), parent);
                return deployment;
            }
            this.deployments = new ArrayList<Deployment>(size);
            for (Activation activation : raXmlDeployment.getActivations()) {
                Deployment raDeployment = this.doDeploy(url, activation, parent);
                this.deployments.add(raDeployment);
                this.kernel.getMainDeployer().registerDeployment(raDeployment);
            }
            Iterator iterator = null;
            return iterator;
        }
        catch (com.github.fungal.spi.deployers.DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            throw new com.github.fungal.spi.deployers.DeployException("Exception during deployment of " + url.toExternalForm(), t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    private Deployment doDeploy(URL url, Activation activation, ClassLoader parent) throws com.github.fungal.spi.deployers.DeployException {
        ClassLoader oldTCCL = SecurityActions.getThreadContextClassLoader();
        try {
            String archive = activation.getArchive();
            URL deployment = null;
            Set deployments = ((RAConfiguration)this.getConfiguration()).getMetadataRepository().getResourceAdapters();
            for (String s : deployments) {
                if (!s.endsWith(archive)) continue;
                deployment = new URL(s);
            }
            if (deployment == null) {
                throw new com.github.fungal.spi.deployers.DeployException("Archive " + archive + " couldn't be resolved in " + url.toExternalForm());
            }
            MetadataRepository mdr = ((RAConfiguration)this.getConfiguration()).getMetadataRepository();
            Connector cmd = mdr.getResourceAdapter(deployment.toExternalForm());
            File root = mdr.getRoot(deployment.toExternalForm());
            if (cmd != null) {
                cmd = (Connector)cmd.copy();
            }
            cmd = new Merger().mergeConnectorWithCommonIronJacamar(activation, cmd);
            URL[] urls = this.getUrls(root);
            KernelClassLoader cl = null;
            cl = ((RAConfiguration)this.getConfiguration()).getScopeDeployment() ? ClassLoaderFactory.create((int)1, (URL[])urls, (ClassLoader)parent) : ClassLoaderFactory.create((int)0, (URL[])urls, (ClassLoader)parent);
            SecurityActions.setThreadContextClassLoader((ClassLoader)cl);
            String deploymentName = archive.substring(0, archive.indexOf(".rar"));
            CommonDeployment c = this.createObjectsAndInjectValue(url, deploymentName, root, (ClassLoader)cl, cmd, activation);
            List<ObjectName> ons = null;
            if (c.isActivateDeployment()) {
                ons = this.registerManagementView(c.getConnector(), this.kernel.getMBeanServer(), this.kernel.getName());
            }
            JndiStrategy jndiStrategy = ((RAConfiguration)this.getConfiguration()).getJndiStrategy();
            MetadataRepository metadataRepository = ((RAConfiguration)this.getConfiguration()).getMetadataRepository();
            ResourceAdapterRepository resourceAdapterRepository = ((RAConfiguration)this.getConfiguration()).getResourceAdapterRepository();
            RaXmlDeployment raXmlDeployment = new RaXmlDeployment(c.getURL(), deployment, c.getDeploymentName(), c.getResourceAdapter(), c.getResourceAdapterKey(), c.getBootstrapContextIdentifier(), jndiStrategy, metadataRepository, resourceAdapterRepository, c.getCfs(), c.getCfJndiNames(), c.getConnectionManagers(), c.getAos(), c.getAoJndiNames(), c.getRecovery(), this.getTransactionIntegration().getRecoveryRegistry(), ((RAConfiguration)this.getConfiguration()).getManagementRepository(), c.getConnector(), this.kernel.getMBeanServer(), ons, cl, c.getLog());
            return raXmlDeployment;
        }
        catch (com.github.fungal.spi.deployers.DeployException de) {
            throw de;
        }
        catch (DeployException cde) {
            throw new com.github.fungal.spi.deployers.DeployException(cde.getMessage(), cde.getCause());
        }
        catch (Throwable t) {
            throw new com.github.fungal.spi.deployers.DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTCCL);
        }
    }

    protected boolean checkActivation(Connector cmd, Activation activation) {
        return true;
    }
}

