/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;

final class LongModelValue
extends ModelValue {
    private final long value;

    LongModelValue(long value) {
        super(ModelType.LONG);
        this.value = value;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    long asLong() {
        return this.value;
    }

    @Override
    long asLong(long defVal) {
        return this.value;
    }

    @Override
    int asInt() {
        return (int)this.value;
    }

    @Override
    int asInt(int defVal) {
        return (int)this.value;
    }

    @Override
    boolean asBoolean() {
        return this.value != 0L;
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return this.value != 0L;
    }

    @Override
    double asDouble() {
        return this.value;
    }

    @Override
    double asDouble(double defVal) {
        return this.value;
    }

    @Override
    byte[] asBytes() {
        byte[] bytes = new byte[]{(byte)(this.value >>> 56), (byte)(this.value >>> 48), (byte)(this.value >>> 40), (byte)(this.value >>> 32), (byte)(this.value >>> 24), (byte)(this.value >>> 16), (byte)(this.value >>> 8), (byte)this.value};
        return bytes;
    }

    @Override
    BigDecimal asBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    String asString() {
        return Long.toString(this.value);
    }

    @Override
    void format(StringBuilder builder, int indent, boolean multiLine) {
        builder.append(this.value).append('L');
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof LongModelValue && this.equals((LongModelValue)other);
    }

    public boolean equals(LongModelValue other) {
        return this == other || other != null && other.value == this.value;
    }

    @Override
    public int hashCode() {
        return (int)this.value;
    }
}

