/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;
import org.jboss.dmr.Property;

final class ObjectModelValue
extends ModelValue {
    private final Map<String, ModelNode> map;

    protected ObjectModelValue() {
        super(ModelType.OBJECT);
        this.map = new LinkedHashMap<String, ModelNode>();
    }

    private ObjectModelValue(Map<String, ModelNode> map) {
        super(ModelType.OBJECT);
        this.map = map;
    }

    ObjectModelValue(DataInput in) throws IOException {
        super(ModelType.OBJECT);
        int count = in.readInt();
        LinkedHashMap<String, ModelNode> map = new LinkedHashMap<String, ModelNode>();
        for (int i = 0; i < count; ++i) {
            String key = in.readUTF();
            ModelNode value = new ModelNode();
            value.readExternal(in);
            map.put(key, value);
        }
        this.map = map;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        Map<String, ModelNode> map = this.map;
        int size = map.size();
        out.writeInt(size);
        for (Map.Entry<String, ModelNode> entry : map.entrySet()) {
            out.writeUTF(entry.getKey());
            entry.getValue().writeExternal(out);
        }
    }

    @Override
    ModelValue protect() {
        Map<String, ModelNode> map = this.map;
        for (ModelNode node : map.values()) {
            node.protect();
        }
        return map.getClass() == LinkedHashMap.class ? new ObjectModelValue(Collections.unmodifiableMap(map)) : this;
    }

    @Override
    ModelNode asObject() {
        return new ModelNode(this.copy());
    }

    @Override
    ModelNode getChild(String name) {
        if (name == null) {
            return null;
        }
        ModelNode node = this.map.get(name);
        if (node != null) {
            return node;
        }
        ModelNode newNode = new ModelNode();
        this.map.put(name, newNode);
        return newNode;
    }

    @Override
    ModelNode removeChild(String name) {
        if (name == null) {
            return null;
        }
        return this.map.remove(name);
    }

    @Override
    int asInt() {
        return this.map.size();
    }

    @Override
    int asInt(int defVal) {
        return this.asInt();
    }

    @Override
    long asLong() {
        return this.asInt();
    }

    @Override
    long asLong(long defVal) {
        return this.asInt();
    }

    @Override
    boolean asBoolean() {
        return !this.map.isEmpty();
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return !this.map.isEmpty();
    }

    @Override
    Property asProperty() {
        if (this.map.size() == 1) {
            Map.Entry<String, ModelNode> entry = this.map.entrySet().iterator().next();
            return new Property(entry.getKey(), entry.getValue());
        }
        return super.asProperty();
    }

    @Override
    List<Property> asPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        for (Map.Entry<String, ModelNode> entry : this.map.entrySet()) {
            propertyList.add(new Property(entry.getKey(), entry.getValue()));
        }
        return propertyList;
    }

    @Override
    ModelValue copy() {
        return this.copy(false);
    }

    @Override
    ModelValue resolve() {
        return this.copy(true);
    }

    ModelValue copy(boolean resolve) {
        LinkedHashMap<String, ModelNode> newMap = new LinkedHashMap<String, ModelNode>();
        for (Map.Entry<String, ModelNode> entry : this.map.entrySet()) {
            newMap.put(entry.getKey(), resolve ? entry.getValue().resolve() : entry.getValue().clone());
        }
        return new ObjectModelValue(newMap);
    }

    @Override
    List<ModelNode> asList() {
        ArrayList<ModelNode> nodes = new ArrayList<ModelNode>();
        for (Map.Entry<String, ModelNode> entry : this.map.entrySet()) {
            ModelNode node = new ModelNode();
            node.set(entry.getKey(), entry.getValue());
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    Set<String> getKeys() {
        return this.map.keySet();
    }

    @Override
    String asString() {
        StringBuilder builder = new StringBuilder();
        this.format(builder, 0, false);
        return builder.toString();
    }

    @Override
    void format(StringBuilder builder, int indent, boolean multiLineRequested) {
        boolean multiLine;
        builder.append('{');
        boolean bl = multiLine = multiLineRequested && this.map.size() > 1;
        if (multiLine) {
            ObjectModelValue.indent(builder.append('\n'), indent + 1);
        }
        Iterator<Map.Entry<String, ModelNode>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ModelNode> entry = iterator.next();
            builder.append(ObjectModelValue.quote(entry.getKey()));
            ModelNode value = entry.getValue();
            builder.append(" => ");
            value.format(builder, multiLine ? indent + 1 : indent, multiLineRequested);
            if (!iterator.hasNext()) continue;
            if (multiLine) {
                ObjectModelValue.indent(builder.append(",\n"), indent + 1);
                continue;
            }
            builder.append(',');
        }
        if (multiLine) {
            ObjectModelValue.indent(builder.append('\n'), indent);
        }
        builder.append('}');
    }

    @Override
    void formatAsJSON(StringBuilder builder, int indent, boolean multiLineRequested) {
        boolean multiLine;
        builder.append('{');
        boolean bl = multiLine = multiLineRequested && this.map.size() > 1;
        if (multiLine) {
            ObjectModelValue.indent(builder.append('\n'), indent + 1);
        }
        Iterator<Map.Entry<String, ModelNode>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ModelNode> entry = iterator.next();
            builder.append(ObjectModelValue.quote(entry.getKey()));
            builder.append(" : ");
            ModelNode value = entry.getValue();
            value.formatAsJSON(builder, multiLine ? indent + 1 : indent, multiLineRequested);
            if (!iterator.hasNext()) continue;
            if (multiLine) {
                ObjectModelValue.indent(builder.append(",\n"), indent + 1);
                continue;
            }
            builder.append(", ");
        }
        if (multiLine) {
            ObjectModelValue.indent(builder.append('\n'), indent);
        }
        builder.append('}');
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ObjectModelValue && this.equals((ObjectModelValue)other);
    }

    public boolean equals(ObjectModelValue other) {
        return this == other || other != null && ((Object)other.map).equals(this.map);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    boolean has(String key) {
        return this.map.containsKey(key);
    }

    @Override
    ModelNode requireChild(String name) throws NoSuchElementException {
        ModelNode node = this.map.get(name);
        if (node != null) {
            return node;
        }
        return super.requireChild(name);
    }
}

