/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.signature;

import java.lang.reflect.Method;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodParametersSignature
extends Signature {
    private int param;

    public MethodParametersSignature(String name, String[] parameters, int param) {
        super(name, parameters);
        this.param = param;
        this.checkParam();
    }

    public MethodParametersSignature(String name, int param, Class<?> ... parameters) {
        super(name, parameters);
        this.param = param;
        this.checkParam();
    }

    public MethodParametersSignature(Method method, int param) {
        super(method.getName(), method.getParameterTypes());
        this.param = param;
        this.checkParam();
    }

    public MethodParametersSignature(MethodInfo method, int param) {
        super(method.getName(), MethodParametersSignature.convertParameterTypes(method.getParameterTypes()));
        this.param = param;
        this.checkParam();
    }

    public int getParam() {
        return this.param;
    }

    protected void checkParam() {
        if (this.param < 0 || this.param >= this.getParameters().length) {
            throw new IllegalArgumentException("param must be between 0 and " + this.getParameters().length);
        }
    }

    @Override
    protected void internalToString(StringBuilder builder) {
        super.internalToString(builder);
        builder.append("#").append(this.param);
    }
}

