/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.annotation.factory.test;

import java.lang.annotation.Annotation;
import junit.framework.Test;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.test.annotation.factory.support.ComplexWithDefault;
import org.jboss.test.annotation.factory.support.MyEnum;
import org.jboss.test.annotation.factory.test.AnnotationCreatorTest;

public class JavassistAnnotationCreatorTestCase
extends AnnotationCreatorTest {
    public static Test suite() {
        return JavassistAnnotationCreatorTestCase.suite(JavassistAnnotationCreatorTestCase.class);
    }

    public JavassistAnnotationCreatorTestCase(String name) {
        super(name);
    }

    public void testDefaultValues() throws Exception {
        String expr = "@org.jboss.test.annotation.factory.support.ComplexWithDefault";
        Annotation annotation = (Annotation)AnnotationCreator.createAnnotation((String)expr, ComplexWithDefault.class);
        JavassistAnnotationCreatorTestCase.assertEquals(ComplexWithDefault.class, annotation.annotationType());
        ComplexWithDefault complex = (ComplexWithDefault)annotation;
        JavassistAnnotationCreatorTestCase.assertEquals((char)'d', (char)complex.ch());
        JavassistAnnotationCreatorTestCase.assertEquals((String)"default", (String)complex.string());
        this.assertEquals(1.0, complex.flt());
        this.assertEquals(2.3, complex.dbl());
        JavassistAnnotationCreatorTestCase.assertEquals((int)2, (int)complex.shrt());
        JavassistAnnotationCreatorTestCase.assertEquals((long)123456789L, (long)complex.lng());
        JavassistAnnotationCreatorTestCase.assertEquals((int)123, (int)complex.integer());
        JavassistAnnotationCreatorTestCase.assertEquals((boolean)true, (boolean)complex.bool());
        JavassistAnnotationCreatorTestCase.assertEquals(String.class, complex.clazz());
        JavassistAnnotationCreatorTestCase.assertEquals((Object)((Object)MyEnum.ONE), (Object)((Object)complex.enumVal()));
        JavassistAnnotationCreatorTestCase.assertEquals((String)"default", (String)complex.annotation().value());
        this.assertEquals(new String[]{"The", "defaults"}, complex.array());
        int[] expectedIntArray = new int[]{1, 2, 3};
        int[] actualIntArray = complex.intArray();
        JavassistAnnotationCreatorTestCase.assertEquals((int)expectedIntArray.length, (int)actualIntArray.length);
        for (int i = 0; i < expectedIntArray.length; ++i) {
            JavassistAnnotationCreatorTestCase.assertEquals((int)expectedIntArray[i], (int)actualIntArray[i]);
        }
    }
}

