/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader;

import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.shared.support.ExpectedMetaData;
import org.jboss.test.metadata.shared.support.NotPresentType;
import org.jboss.test.metadata.shared.support.TestMetaData;
import org.jboss.test.metadata.shared.support.TestMetaData1;
import org.jboss.test.metadata.shared.support.TestMetaData1Impl;
import org.jboss.test.metadata.shared.support.TestMetaData2;
import org.jboss.test.metadata.shared.support.TestMetaData2Impl;
import org.jboss.test.metadata.shared.support.TestMetaDataImpl;

public abstract class MutableMetaDataLoaderMetaDataInvalidationTest
extends AbstractMetaDataTest {
    public MutableMetaDataLoaderMetaDataInvalidationTest(String name) {
        super(name);
    }

    public void testEmpty() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        this.assertValidTimeUnchanged((MetaDataRetrieval)metaData, last);
    }

    public void testTestMetaData() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData((MetaDataRetrieval)metaData, TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), TestMetaData.class, expected, last);
        this.assertMetaData((MetaDataRetrieval)metaData, TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        this.assertRemoveMetaData(metaData, TestMetaData.class, expected, last);
        this.assertNoMetaData((MetaDataRetrieval)metaData, TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testTestMetaData12() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData((MetaDataRetrieval)metaData, TestMetaData1.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, TestMetaData2.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaData1Impl(), TestMetaData1.class, expected, last);
        this.assertMetaData((MetaDataRetrieval)metaData, TestMetaData1.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, TestMetaData2.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaData2Impl(), TestMetaData2.class, expected, last);
        this.assertMetaData((MetaDataRetrieval)metaData, TestMetaData1.class);
        this.assertMetaData((MetaDataRetrieval)metaData, TestMetaData2.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        this.assertRemoveMetaData(metaData, TestMetaData1.class, expected, last);
        this.assertNoMetaData((MetaDataRetrieval)metaData, TestMetaData1.class);
        this.assertMetaData((MetaDataRetrieval)metaData, TestMetaData2.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        this.assertRemoveMetaData(metaData, TestMetaData2.class, expected, last);
        this.assertNoMetaData((MetaDataRetrieval)metaData, TestMetaData1.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, TestMetaData2.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testAddTwice() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData((MetaDataRetrieval)metaData, TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), TestMetaData.class, expected, last);
        this.assertMetaData((MetaDataRetrieval)metaData, TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        last = this.assertAddMetaDataWithPrevious(metaData, new TestMetaDataImpl(), TestMetaData.class, last);
        this.assertMetaData((MetaDataRetrieval)metaData, TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testAddTwiceSameObject() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData((MetaDataRetrieval)metaData, TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        TestMetaDataImpl object = new TestMetaDataImpl();
        last = this.assertAddMetaDataNoPrevious(metaData, object, TestMetaData.class, expected, last);
        this.assertMetaData((MetaDataRetrieval)metaData, TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        this.assertAddMetaDataWithPreviousSameObject(metaData, object, TestMetaData.class, last);
        this.assertMetaData((MetaDataRetrieval)metaData, TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testRemoveDoesNotExist() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNotRemovedMetaData(metaData, TestMetaData.class, last);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testRemoveTwice() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), TestMetaData.class, expected, last);
        this.assertRemoveMetaData(metaData, TestMetaData.class, expected, last);
        this.assertNotRemovedMetaData(metaData, TestMetaData.class, last);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testTestMetaDataByName() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData((MetaDataRetrieval)metaData, "Test", TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), "Test", TestMetaData.class, expected, last);
        this.assertMetaData((MetaDataRetrieval)metaData, "Test", TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        this.assertRemoveMetaData(metaData, "Test", TestMetaData.class, expected, last);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "Test", TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testTestMetaData12ByName() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData((MetaDataRetrieval)metaData, "Test1", TestMetaData1.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "Test2", TestMetaData2.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaData1Impl(), "Test1", TestMetaData1.class, expected, last);
        this.assertMetaData((MetaDataRetrieval)metaData, "Test1", TestMetaData1.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "Test2", TestMetaData2.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaData2Impl(), "Test2", TestMetaData2.class, expected, last);
        this.assertMetaData((MetaDataRetrieval)metaData, "Test1", TestMetaData1.class);
        this.assertMetaData((MetaDataRetrieval)metaData, "Test2", TestMetaData2.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        this.assertRemoveMetaData(metaData, "Test1", TestMetaData1.class, expected, last);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "Test1", TestMetaData1.class);
        this.assertMetaData((MetaDataRetrieval)metaData, "Test2", TestMetaData2.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        this.assertRemoveMetaData(metaData, "Test2", TestMetaData2.class, expected, last);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "Test1", TestMetaData1.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "Test2", TestMetaData2.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testAddTwiceByName() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData((MetaDataRetrieval)metaData, "Test", TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), "Test", TestMetaData.class, expected, last);
        this.assertMetaData((MetaDataRetrieval)metaData, "Test", TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        last = this.assertAddMetaDataWithPrevious(metaData, new TestMetaDataImpl(), "Test", TestMetaData.class, last);
        this.assertMetaData((MetaDataRetrieval)metaData, "Test", TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testAddTwiceSameObjectByName() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNoMetaData((MetaDataRetrieval)metaData, "Test", TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        TestMetaDataImpl object = new TestMetaDataImpl();
        last = this.assertAddMetaDataNoPrevious(metaData, object, "Test", TestMetaData.class, expected, last);
        this.assertMetaData((MetaDataRetrieval)metaData, "Test", TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
        this.assertAddMetaDataWithPreviousSameObject(metaData, object, "Test", TestMetaData.class, last);
        this.assertMetaData((MetaDataRetrieval)metaData, "Test", TestMetaData.class);
        this.assertNoMetaData((MetaDataRetrieval)metaData, "NotPresent", NotPresentType.class);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testRemoveDoesNotExistByName() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        this.assertNotRemovedMetaData(metaData, "Test", TestMetaData.class, last);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    public void testRemoveTwiceByName() throws Exception {
        MutableMetaDataLoader metaData = this.setupEmpty();
        long last = metaData.getValidTime().getValidTime();
        ExpectedMetaData expected = this.emptyExpectedMetaData();
        last = this.assertAddMetaDataNoPrevious(metaData, new TestMetaDataImpl(), "Test", TestMetaData.class, expected, last);
        this.assertRemoveMetaData(metaData, "Test", TestMetaData.class, expected, last);
        this.assertNotRemovedMetaData(metaData, "Test", TestMetaData.class, last);
        this.assertAllMetaData((MetaDataRetrieval)metaData, expected);
    }

    protected abstract MutableMetaDataLoader setupEmpty();
}

