/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.context.cache.test;

import java.lang.annotation.Annotation;
import java.util.List;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.plugins.context.CachingMetaDataContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.loader.MetaDataLoader;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationItem;
import org.jboss.metadata.spi.retrieval.basic.BasicAnnotationsItem;
import org.jboss.test.metadata.context.AbstractMetaDataContextTest;
import org.jboss.test.metadata.context.cache.support.TestMetaDataLoader;
import org.jboss.test.metadata.shared.support.TestAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCacheParentMetaDataContextUnitTestCase
extends AbstractMetaDataContextTest {
    public SimpleCacheParentMetaDataContextUnitTestCase(String name) {
        super(name);
    }

    @Override
    protected MetaDataRetrieval createRetrieval() {
        return new TestMetaDataLoader();
    }

    @Override
    protected MetaDataContext createContext(MetaDataContext parent, List<MetaDataRetrieval> retrievals) {
        return new CachingMetaDataContext(parent, retrievals);
    }

    @Override
    protected MetaDataContext createChildContext(MetaDataContext parent, List<MetaDataRetrieval> retrievals) {
        return new AbstractMetaDataContext(parent, retrievals);
    }

    protected TestMetaDataLoader getFirstParent() {
        return (TestMetaDataLoader)this.firstParent;
    }

    protected TestMetaDataLoader getSecondParent() {
        return (TestMetaDataLoader)this.secondParent;
    }

    protected TestMetaDataLoader getFirstChild() {
        return (TestMetaDataLoader)this.firstChild;
    }

    protected TestMetaDataLoader getSecondChild() {
        return (TestMetaDataLoader)this.secondChild;
    }

    protected <T extends Annotation> BasicAnnotationItem<T> createAnnotationItem(TestMetaDataLoader loader, T annotation, Class<T> type) {
        return new BasicAnnotationItem((MetaDataLoader)loader, annotation);
    }

    protected <T extends Annotation> void setAnnotations(TestMetaDataLoader loader, AnnotationItem<T> annotationItem) {
        AnnotationItem[] items = new AnnotationItem[]{annotationItem};
        BasicAnnotationsItem item = new BasicAnnotationsItem((MetaDataLoader)loader, items);
        loader.setAnnotationsItem((AnnotationsItem)item);
    }

    protected void testAnnotation(MetaData metaData, TestMetaDataLoader loader, boolean isChild) throws Exception {
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)loader.isRetrieved());
        BasicAnnotationItem<TestAnnotation> annotationItem = this.createAnnotationItem(loader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(loader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)loader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertEquals((boolean)isChild, (boolean)loader.isRetrieved());
        loader.clear();
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)loader.isRetrieved());
    }

    public void testAnnotationFirstChild() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAnnotation(metaData, this.getFirstChild(), true);
    }

    public void testAnnotationSecondChild() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAnnotation(metaData, this.getSecondChild(), true);
    }

    public void testAnnotationFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAnnotation(metaData, this.getFirstParent(), false);
    }

    public void testAnnotationSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAnnotation(metaData, this.getSecondParent(), false);
    }

    protected void testBelowAnnotation(MetaData metaData, TestMetaDataLoader aboveLoader, TestMetaDataLoader belowLoader, boolean aboveChild, boolean belowChild) throws Exception {
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        BasicAnnotationItem<TestAnnotation> annotationItem = this.createAnnotationItem(aboveLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(aboveLoader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertEquals((boolean)aboveChild, (boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem = this.createAnnotationItem(belowLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(belowLoader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertEquals((boolean)aboveChild, (boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem.invalidate();
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertEquals((boolean)aboveChild, (boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        belowLoader.clear();
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        aboveLoader.clear();
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
    }

    public void testBelowAnnotationFirstChildSecondChild() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getFirstChild(), this.getSecondChild(), true, true);
    }

    public void testBelowAnnotationFirstChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getFirstChild(), this.getFirstParent(), true, false);
    }

    public void testBelowAnnotationFirstChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getFirstChild(), this.getSecondParent(), true, false);
    }

    public void testBelowAnnotationSecondChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getSecondChild(), this.getFirstParent(), true, false);
    }

    public void testBelowAnnotationSecondChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getSecondChild(), this.getSecondParent(), true, false);
    }

    public void testBelowAnnotationFirstParentSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testBelowAnnotation(metaData, this.getFirstParent(), this.getSecondParent(), false, false);
    }

    protected void testAboveAnnotation(MetaData metaData, TestMetaDataLoader aboveLoader, TestMetaDataLoader belowLoader, boolean aboveChild, boolean belowChild) throws Exception {
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        BasicAnnotationItem<TestAnnotation> annotationItem = this.createAnnotationItem(belowLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(belowLoader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertEquals((boolean)aboveChild, (boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertEquals((boolean)belowChild, (boolean)belowLoader.isRetrieved());
        annotationItem = this.createAnnotationItem(aboveLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(aboveLoader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertEquals((boolean)aboveChild, (boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        belowLoader.clear();
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        annotationItem = this.createAnnotationItem(belowLoader, new TestAnnotationImpl(), TestAnnotation.class);
        this.setAnnotations(belowLoader, (AnnotationItem)annotationItem);
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertEquals((boolean)aboveChild, (boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertFalse((boolean)belowLoader.isRetrieved());
        aboveLoader.clear();
        this.assertAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
        belowLoader.clear();
        this.assertNoAnnotation(metaData, TestAnnotation.class);
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)aboveLoader.isRetrieved());
        SimpleCacheParentMetaDataContextUnitTestCase.assertTrue((boolean)belowLoader.isRetrieved());
    }

    public void testAboveAnnotationFirstChildSecondChild() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getFirstChild(), this.getSecondChild(), true, true);
    }

    public void testAboveAnnotationFirstChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getFirstChild(), this.getFirstParent(), true, false);
    }

    public void testAboveAnnotationFirstChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getFirstChild(), this.getSecondParent(), true, false);
    }

    public void testAboveAnnotationSecondChildFirstParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getSecondChild(), this.getFirstParent(), true, false);
    }

    public void testAboveAnnotationSecondChildSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getSecondChild(), this.getSecondParent(), true, false);
    }

    public void testAboveAnnotationFirstParentSecondParent() throws Exception {
        MetaData metaData = this.createTestContext();
        this.testAboveAnnotation(metaData, this.getFirstParent(), this.getSecondParent(), false, false);
    }
}

