/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader;

import java.lang.annotation.Annotation;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.shared.support.RestrictedAnnotationImpl;
import org.jboss.test.metadata.shared.support.RestrictedImpl;
import org.jboss.test.metadata.shared.support.RestrictedInterface;
import org.jboss.test.metadata.shared.support.TestAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotationImpl;

public abstract class MutableRestrictedTest
extends AbstractMetaDataTest {
    public MutableRestrictedTest(String name) {
        super(name);
    }

    protected abstract MutableMetaDataLoader setUpRestricted();

    public void testRestrictedAnnotation() throws Exception {
        MutableMetaDataLoader loader = this.setUpRestricted();
        TestAnnotationImpl testAnnotation = new TestAnnotationImpl();
        loader.addAnnotation((Annotation)testAnnotation);
        MutableRestrictedTest.assertNotNull((Object)loader.retrieveAnnotation(TestAnnotation.class));
        RestrictedAnnotationImpl restrictedAnnotation = new RestrictedAnnotationImpl();
        try {
            loader.addAnnotation((Annotation)restrictedAnnotation);
        }
        catch (Throwable t) {
            MutableRestrictedTest.checkThrowable(SecurityException.class, (Throwable)t);
        }
    }

    public void testRestrictedMetaData() throws Exception {
        MutableMetaDataLoader loader = this.setUpRestricted();
        Object object = new Object();
        loader.addMetaData(object, Object.class);
        MutableRestrictedTest.assertNotNull((Object)loader.retrieveMetaData(Object.class));
        RestrictedImpl restrictedMetaData = new RestrictedImpl();
        try {
            loader.addMetaData((Object)restrictedMetaData, RestrictedInterface.class);
        }
        catch (Throwable t) {
            MutableRestrictedTest.checkThrowable(SecurityException.class, (Throwable)t);
        }
    }

    public void testRestrictedMetaDataByName() throws Exception {
        MutableMetaDataLoader loader = this.setUpRestricted();
        Object object = new Object();
        loader.addMetaData("Object", object, Object.class);
        MutableRestrictedTest.assertNotNull((Object)loader.retrieveMetaData("Object"));
        RestrictedImpl restrictedMetaData = new RestrictedImpl();
        try {
            loader.addMetaData("Restricted", (Object)restrictedMetaData, RestrictedInterface.class);
        }
        catch (Throwable t) {
            MutableRestrictedTest.checkThrowable(SecurityException.class, (Throwable)t);
        }
    }
}

