/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader.memory.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.loader.thread.ThreadLocalMetaDataLoader;
import org.jboss.metadata.spi.ComponentMutableMetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MemberInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.test.metadata.SignatureMetaDataTest;
import org.jboss.test.metadata.shared.support.TestAnnotation;
import org.jboss.test.metadata.shared.support.TestAnnotationImpl;

public class MemoryLoaderComponentMutableUnitTestCase
extends SignatureMetaDataTest {
    public MemoryLoaderComponentMutableUnitTestCase(String name) {
        super(name);
    }

    protected ComponentMutableMetaData[] getArray() {
        ComponentMutableMetaData[] array = new ComponentMutableMetaData[10];
        array[0] = new MemoryMetaDataLoader();
        array[1] = new MemoryMetaDataLoader(true, true);
        array[2] = new MemoryMetaDataLoader(true, false);
        array[3] = new MemoryMetaDataLoader(false, true);
        array[4] = new MemoryMetaDataLoader(false, false);
        ScopeKey key = new ScopeKey(CommonLevels.APPLICATION, (Object)"SignatureTester");
        array[5] = new MemoryMetaDataLoader(key);
        array[6] = new MemoryMetaDataLoader(key, true, true);
        array[7] = new MemoryMetaDataLoader(key, true, false);
        array[8] = new MemoryMetaDataLoader(key, false, true);
        array[9] = new MemoryMetaDataLoader(key, false, false);
        return array;
    }

    public void testComponentMetaDataRetrieval() throws Exception {
        ComponentMutableMetaData[] array = this.getArray();
        Signature[] signatures = this.getSignatures();
        ThreadLocalMetaDataLoader retrieval = ThreadLocalMetaDataLoader.INSTANCE;
        for (ComponentMutableMetaData cmmd : array) {
            for (Signature sig : signatures) {
                MemoryLoaderComponentMutableUnitTestCase.assertNull((Object)cmmd.addComponentMetaDataRetrieval(sig, (MetaDataRetrieval)retrieval));
                MetaDataRetrieval mdr = cmmd.removeComponentMetaDataRetrieval(sig);
                MemoryLoaderComponentMutableUnitTestCase.assertSame((Object)retrieval, (Object)mdr);
            }
        }
    }

    public void testAnnotations() throws Exception {
        ComponentMutableMetaData[] array = this.getArray();
        Signature[] signatures = this.getSignatures();
        TestAnnotationImpl annotation = new TestAnnotationImpl();
        for (ComponentMutableMetaData cmmd : array) {
            for (Signature sig : signatures) {
                MemoryLoaderComponentMutableUnitTestCase.assertNull((Object)cmmd.addAnnotation(sig, (Annotation)annotation));
                MemoryLoaderComponentMutableUnitTestCase.assertSame((Object)annotation, (Object)cmmd.removeAnnotation(sig, TestAnnotation.class));
            }
        }
        Constructor<?> c = this.getConstructor();
        ConstructorInfo ci = this.getConstructorInfo();
        ConstructorSignature sc = new ConstructorSignature(c);
        this.checkAnnotationCycle((Signature)sc, c, (MemberInfo)ci);
        Method m = this.getMethod();
        MethodInfo mi = this.getMethodInfo();
        MethodSignature sm = new MethodSignature(m);
        this.checkAnnotationCycle((Signature)sm, m, (MemberInfo)mi);
        Field f = this.getField();
        FieldInfo fi = this.getFieldInfo();
        FieldSignature sf = new FieldSignature(f);
        this.checkAnnotationCycle((Signature)sf, f, (MemberInfo)fi);
    }

    public void testMetaData() throws Exception {
        ComponentMutableMetaData[] array = this.getArray();
        Signature[] signatures = this.getSignatures();
        Object metadata = new Object();
        for (ComponentMutableMetaData cmmd : array) {
            for (Signature sig : signatures) {
                MemoryLoaderComponentMutableUnitTestCase.assertNull((Object)cmmd.addMetaData(sig, metadata, Object.class));
                Object object = cmmd.removeMetaData(sig, Object.class);
                MemoryLoaderComponentMutableUnitTestCase.assertSame((Object)metadata, (Object)object);
            }
        }
        Constructor<?> c = this.getConstructor();
        ConstructorInfo ci = this.getConstructorInfo();
        ConstructorSignature sc = new ConstructorSignature(c);
        this.checkMetaDataCycle((Signature)sc, c, (MemberInfo)ci);
        Method m = this.getMethod();
        MethodInfo mi = this.getMethodInfo();
        MethodSignature sm = new MethodSignature(m);
        this.checkMetaDataCycle((Signature)sm, m, (MemberInfo)mi);
        Field f = this.getField();
        FieldInfo fi = this.getFieldInfo();
        FieldSignature sf = new FieldSignature(f);
        this.checkMetaDataCycle((Signature)sf, f, (MemberInfo)fi);
    }

    protected void checkAnnotationCycle(Signature signature, Member member, MemberInfo memberInfo) throws Exception {
        ComponentMutableMetaData[] array;
        TestAnnotationImpl annotation = new TestAnnotationImpl();
        for (ComponentMutableMetaData cmmd : array = this.getArray()) {
            MemoryLoaderComponentMutableUnitTestCase.assertNull((Object)cmmd.addAnnotation(signature, (Annotation)annotation));
            MemoryLoaderComponentMutableUnitTestCase.assertSame((Object)annotation, (Object)cmmd.removeAnnotation(member, annotation.annotationType()));
            MemoryLoaderComponentMutableUnitTestCase.assertNull((Object)cmmd.addAnnotation(memberInfo, (Annotation)annotation));
            MemoryLoaderComponentMutableUnitTestCase.assertSame((Object)annotation, (Object)cmmd.removeAnnotation(signature, annotation.annotationType()));
        }
    }

    protected void checkMetaDataCycle(Signature signature, Member member, MemberInfo memberInfo) throws Exception {
        ComponentMutableMetaData[] array;
        Object metadata = new Object();
        for (ComponentMutableMetaData cmmd : array = this.getArray()) {
            MemoryLoaderComponentMutableUnitTestCase.assertNull((Object)cmmd.addMetaData(signature, metadata, Object.class));
            MemoryLoaderComponentMutableUnitTestCase.assertSame((Object)metadata, (Object)cmmd.removeMetaData(member, Object.class));
            MemoryLoaderComponentMutableUnitTestCase.assertNull((Object)cmmd.addMetaData(memberInfo, metadata, Object.class));
            MemoryLoaderComponentMutableUnitTestCase.assertSame((Object)metadata, (Object)cmmd.removeMetaData(signature, Object.class));
        }
    }
}

