/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.metadata.loader.custom.support;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.jboss.metadata.plugins.loader.AbstractMetaDataLoader;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationItem;
import org.jboss.metadata.spi.retrieval.simple.SimpleAnnotationsItem;
import org.jboss.metadata.spi.signature.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAnnotationMetaDataLoader
extends AbstractMetaDataLoader {
    private List<Annotation> annotations;

    public TestAnnotationMetaDataLoader(Annotation ... annotations) {
        this.annotations = Arrays.asList(annotations);
    }

    public MetaDataRetrieval getComponentMetaDataRetrieval(Signature signature) {
        return null;
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    public <T extends Annotation> AnnotationItem<T> retrieveAnnotation(Class<T> annotationType) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return new SimpleAnnotationItem((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    public AnnotationsItem retrieveAnnotations() {
        if (this.annotations.isEmpty()) {
            return SimpleAnnotationsItem.NO_ANNOTATIONS;
        }
        Annotation[] annotations = this.annotations.toArray(new Annotation[0]);
        AnnotationItem[] items = new AnnotationItem[annotations.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new SimpleAnnotationItem(annotations[i]);
        }
        return new SimpleAnnotationsItem(items);
    }
}

