/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceAuthorityType;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceProcessor<E extends AnnotatedElement>
extends AbstractFinderUser {
    private static Logger log = Logger.getLogger(AbstractResourceProcessor.class);
    private static final Set<String> envEntryTypes = new HashSet<String>();
    private static final Set<String> serviceRefTypes = new HashSet<String>();
    private static final Set<String> resourceRefTypes = new HashSet<String>();
    private static final Set<String> messageDestRefRefTypes = new HashSet<String>();

    public static boolean isEnvEntry(String type) {
        return envEntryTypes.contains(type);
    }

    public static boolean isServiceRef(String type) {
        return serviceRefTypes.contains(type);
    }

    public static boolean isResourceRef(String type) {
        return resourceRefTypes.contains(type);
    }

    public static boolean isMessageDestinationRef(String type) {
        return messageDestRefRefTypes.contains(type);
    }

    protected AbstractResourceProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(EnvironmentRefsGroupMetaData refs, E element) {
        Resource annotation = this.finder.getAnnotation(element, Resource.class);
        if (annotation == null) {
            return;
        }
        this.process(refs, element, annotation);
    }

    protected void process(EnvironmentRefsGroupMetaData refs, E element, Resource annotation) {
        boolean trace = log.isTraceEnabled();
        String type = annotation.type().getName();
        if (type.equals("java.lang.Object")) {
            type = this.getType(element);
        }
        if (trace) {
            log.trace((Object)("process: " + annotation + ", type=" + type));
        }
        if (AbstractResourceProcessor.isEnvEntry(type)) {
            EnvironmentEntriesMetaData env = refs.getEnvironmentEntries();
            if (env == null) {
                env = new EnvironmentEntriesMetaData();
                refs.setEnvironmentEntries(env);
            }
            EnvironmentEntryMetaData entry = this.createEntry(annotation, element);
            env.add(entry);
            if (trace) {
                log.trace((Object)("created env-entry: " + entry));
            }
        } else if (AbstractResourceProcessor.isServiceRef(type)) {
            ServiceReferencesMetaData srefs = refs.getServiceReferences();
            if (srefs == null) {
                srefs = new ServiceReferencesMetaData();
                refs.setServiceReferences(srefs);
            }
            ServiceReferenceMetaData ref = this.createServiceRef(annotation, element);
            srefs.add(ref);
            if (trace) {
                log.trace((Object)("created service-ref: " + ref));
            }
        } else if (AbstractResourceProcessor.isResourceRef(type)) {
            ResourceReferencesMetaData resRefs = refs.getResourceReferences();
            if (resRefs == null) {
                resRefs = new ResourceReferencesMetaData();
                refs.setResourceReferences(resRefs);
            }
            ResourceReferenceMetaData ref = this.createResourceRef(annotation, element);
            resRefs.add(ref);
            if (trace) {
                log.trace((Object)("created resource-ref: " + ref));
            }
        } else if (AbstractResourceProcessor.isMessageDestinationRef(type)) {
            MessageDestinationReferencesMetaData mrefs = refs.getMessageDestinationReferences();
            if (mrefs == null) {
                mrefs = new MessageDestinationReferencesMetaData();
                refs.setMessageDestinationReferences(mrefs);
            }
            MessageDestinationReferenceMetaData ref = this.createMessageRef(annotation, element);
            mrefs.add(ref);
            if (trace) {
                log.trace((Object)("created message-destination-ref: " + ref));
            }
        } else {
            ResourceEnvironmentReferencesMetaData resRefs = refs.getResourceEnvironmentReferences();
            if (resRefs == null) {
                resRefs = new ResourceEnvironmentReferencesMetaData();
                refs.setResourceEnvironmentReferences(resRefs);
            }
            ResourceEnvironmentReferenceMetaData ref = this.createResourceEnvRef(annotation, element);
            resRefs.add(ref);
            if (trace) {
                log.trace((Object)("created resource-env-ref: " + ref));
            }
        }
    }

    protected abstract String getName(E var1);

    protected abstract String getInjectionName(E var1);

    protected abstract String getType(E var1);

    protected abstract String getDeclaringClass(E var1);

    protected ResourceReferenceMetaData createResourceRef(Resource annotation, E element) {
        Descriptions descriptions;
        ResourceReferenceMetaData ref = new ResourceReferenceMetaData();
        String name = annotation.name();
        if (name.length() == 0) {
            name = this.getName(element);
        }
        ref.setResourceRefName(name);
        Resource.AuthenticationType authType = annotation.authenticationType();
        ResourceAuthorityType resAuthType = ResourceAuthorityType.Container;
        if (authType == Resource.AuthenticationType.APPLICATION) {
            resAuthType = ResourceAuthorityType.Application;
        }
        ref.setResAuth(resAuthType);
        if (annotation.mappedName().length() > 0) {
            ref.setMappedName(annotation.mappedName());
        }
        if ((descriptions = ProcessorUtils.getDescription(annotation.description())) != null) {
            ref.setDescriptions(descriptions);
        }
        if (annotation.type() != Object.class) {
            ref.setType(annotation.type().getName());
        } else {
            ref.setType(this.getType(element));
        }
        String injectionName = this.getInjectionName(element);
        Set<ResourceInjectionTargetMetaData> injectionTargets = ProcessorUtils.getInjectionTargets(injectionName, element);
        if (injectionTargets != null) {
            ref.setInjectionTargets(injectionTargets);
        }
        return ref;
    }

    protected EnvironmentEntryMetaData createEntry(Resource annotation, E element) {
        String injectionName;
        Set<ResourceInjectionTargetMetaData> injectionTargets;
        EnvironmentEntryMetaData entry = new EnvironmentEntryMetaData();
        String name = annotation.name();
        if (name.length() == 0) {
            name = this.getName(element);
        }
        entry.setEnvEntryName(name);
        Descriptions descriptions = ProcessorUtils.getDescription(annotation.description());
        if (descriptions != null) {
            entry.setDescriptions(descriptions);
        }
        if (annotation.type() != Object.class) {
            entry.setType(annotation.type().getName());
        } else {
            entry.setType(this.getType(element));
        }
        if (annotation.mappedName().length() > 0) {
            entry.setValue(annotation.mappedName());
        }
        if ((injectionTargets = ProcessorUtils.getInjectionTargets(injectionName = this.getInjectionName(element), element)) != null) {
            entry.setInjectionTargets(injectionTargets);
        }
        return entry;
    }

    protected ServiceReferenceMetaData createServiceRef(Resource annotation, E element) {
        ServiceReferenceMetaData ref = new ServiceReferenceMetaData();
        String name = annotation.name();
        if (name.length() == 0) {
            name = this.getName(element);
        }
        ref.setServiceRefName(name);
        if (annotation.mappedName().length() > 0) {
            ref.setMappedName(annotation.mappedName());
        }
        ref.setAnnotatedElement((AnnotatedElement)element);
        DescriptionGroupMetaData dg = ProcessorUtils.getDescriptionGroup(annotation.description());
        if (dg != null) {
            ref.setDescriptionGroup(dg);
        }
        if (annotation.type() != Object.class) {
            ref.setServiceRefType(annotation.type().getName());
        } else {
            ref.setServiceRefType(this.getType(element));
        }
        String injectionName = this.getInjectionName(element);
        Set<ResourceInjectionTargetMetaData> injectionTargets = ProcessorUtils.getInjectionTargets(injectionName, element);
        if (injectionTargets != null) {
            ref.setInjectionTargets(injectionTargets);
        }
        return ref;
    }

    protected MessageDestinationReferenceMetaData createMessageRef(Resource annotation, E element) {
        String injectionName;
        Set<ResourceInjectionTargetMetaData> injectionTargets;
        MessageDestinationReferenceMetaData ref = new MessageDestinationReferenceMetaData();
        String name = annotation.name();
        if (name.length() == 0) {
            name = this.getName(element);
        }
        ref.setMessageDestinationRefName(name);
        if (annotation.mappedName().length() > 0) {
            ref.setMappedName(annotation.mappedName());
        }
        if (annotation.type() != Object.class) {
            ref.setType(annotation.type().getName());
        } else {
            ref.setType(this.getType(element));
        }
        Descriptions descriptions = ProcessorUtils.getDescription(annotation.description());
        if (descriptions != null) {
            ref.setDescriptions(descriptions);
        }
        if ((injectionTargets = ProcessorUtils.getInjectionTargets(injectionName = this.getInjectionName(element), element)) != null) {
            ref.setInjectionTargets(injectionTargets);
        }
        return ref;
    }

    protected ResourceEnvironmentReferenceMetaData createResourceEnvRef(Resource annotation, E element) {
        String injectionName;
        Set<ResourceInjectionTargetMetaData> injectionTargets;
        ResourceEnvironmentReferenceMetaData ref = new ResourceEnvironmentReferenceMetaData();
        String name = annotation.name();
        if (name.length() == 0) {
            name = this.getName(element);
        }
        ref.setResourceEnvRefName(name);
        if (annotation.mappedName().length() > 0) {
            ref.setMappedName(annotation.mappedName());
        }
        if (annotation.type() != Object.class) {
            ref.setType(annotation.type().getName());
        } else {
            ref.setType(this.getType(element));
        }
        Descriptions descriptions = ProcessorUtils.getDescription(annotation.description());
        if (descriptions != null) {
            ref.setDescriptions(descriptions);
        }
        if ((injectionTargets = ProcessorUtils.getInjectionTargets(injectionName = this.getInjectionName(element), element)) != null) {
            ref.setInjectionTargets(injectionTargets);
        }
        return ref;
    }

    static {
        envEntryTypes.add("java.lang.String");
        envEntryTypes.add("java.lang.Character");
        envEntryTypes.add("java.lang.Integer");
        envEntryTypes.add("java.lang.Boolean");
        envEntryTypes.add("java.lang.Double");
        envEntryTypes.add("java.lang.Byte");
        envEntryTypes.add("java.lang.Short");
        envEntryTypes.add("java.lang.Float");
        envEntryTypes.add("java.lang.Long");
        envEntryTypes.add("char");
        envEntryTypes.add("int");
        envEntryTypes.add("boolean");
        envEntryTypes.add("double");
        envEntryTypes.add("byte");
        envEntryTypes.add("short");
        envEntryTypes.add("float");
        envEntryTypes.add("long");
        serviceRefTypes.add("javax.xml.rpc.Service");
        serviceRefTypes.add("javax.xml.ws.Service");
        serviceRefTypes.add("javax.jws.WebService");
        resourceRefTypes.add("javax.sql.DataSource");
        resourceRefTypes.add("javax.jms.ConnectionFactory");
        resourceRefTypes.add("javax.jms.QueueConnectionFactory");
        resourceRefTypes.add("javax.jms.TopicConnectionFactory");
        resourceRefTypes.add("javax.mail.Session");
        resourceRefTypes.add("java.net.URL");
        resourceRefTypes.add("javax.resource.cci.ConnectionFactory");
        resourceRefTypes.add("org.omg.CORBA_2_3.ORB");
        messageDestRefRefTypes.add("javax.jms.Queue");
        messageDestRefRefTypes.add("javax.jms.Topic");
        messageDestRefRefTypes.add("javax.jms.TemporaryQueue");
        messageDestRefRefTypes.add("javax.jms.TemporaryTopic");
    }
}

