/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.reflect.AnnotatedElement;
import javax.ejb.EJBLocalObject;
import javax.ejb.Local;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.lang.ClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalProcessor
extends AbstractFinderUser
implements Processor<SessionBeanMetaData, Class<?>> {
    public LocalProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    protected void addBusinessInterface(SessionBeanMetaData metaData, Class<?> businessInterface) {
        if (EJBLocalObject.class.isAssignableFrom(businessInterface)) {
            if (metaData.getLocal() != null) {
                throw new IllegalArgumentException("2.1 bean " + metaData.getEjbName() + " already has a local interface " + metaData.getLocal() + ", can't add " + businessInterface.getName());
            }
            metaData.setLocal(businessInterface.getName());
        } else {
            if (metaData.getBusinessLocals() == null) {
                metaData.setBusinessLocals(new BusinessLocalsMetaData());
            }
            metaData.getBusinessLocals().add(businessInterface.getName());
        }
    }

    @Override
    public void process(SessionBeanMetaData metaData, Class<?> type) {
        Local local = this.finder.getAnnotation(type, Local.class);
        if (local == null) {
            return;
        }
        if (type.isInterface()) {
            this.addBusinessInterface(metaData, type);
        } else if (local.value() == null || local.value().length == 0) {
            Class<?> businessInterface = ClassHelper.getDefaultInterface(type);
            this.addBusinessInterface(metaData, businessInterface);
        } else {
            for (Class businessInterface : local.value()) {
                this.addBusinessInterface(metaData, businessInterface);
            }
        }
    }
}

