/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import javax.ejb.Remove;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.RemoveMethodMetaData;
import org.jboss.metadata.ejb.spec.RemoveMethodsMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveProcessor
extends AbstractFinderUser
implements Creator<Method, RemoveMethodMetaData>,
Processor<SessionBeanMetaData, Method> {
    public RemoveProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public RemoveMethodMetaData create(Method method) {
        Remove remove = this.finder.getAnnotation(method, Remove.class);
        if (remove == null) {
            return null;
        }
        RemoveMethodMetaData metaData = new RemoveMethodMetaData();
        NamedMethodMetaData beanMethod = new NamedMethodMetaData();
        beanMethod.setMethodName(method.getName());
        metaData.setBeanMethod(beanMethod);
        metaData.setRetainIfException(remove.retainIfException());
        MethodParametersMetaData methodParams = ProcessorUtils.getMethodParameters(method);
        beanMethod.setMethodParams(methodParams);
        return metaData;
    }

    @Override
    public void process(SessionBeanMetaData bean, Method method) {
        RemoveMethodMetaData removeMethod = this.create(method);
        if (removeMethod == null) {
            return;
        }
        if (bean.getSessionType() != SessionType.Stateful) {
            throw new IllegalArgumentException("Remove annotation is only valid on a stateful bean");
        }
        if (bean.getRemoveMethods() == null) {
            bean.setRemoveMethods(new RemoveMethodsMetaData());
        }
        bean.getRemoveMethods().add(removeMethod);
    }
}

