/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.reflect.plugins.javassist.classpool;


import javassist.ClassPool;
import javassist.scopedpool.ScopedClassPoolRepository;

/**
 * This ClassPoolFactory is tailored for use with scoped class pools.
 * In order to retrieve a ClassPool, this factory registers the
 * corresponding ClassLoader with
 * {@link ScopedClassPoolRepository#registerClassLoader(ClassLoader)}.
 * For that reason, it is important to register a ScopedClassPoolFactory
 * ({@link ScopedClassPoolRepository#setClassPoolFactory(javassist.scopedpool.ScopedClassPoolFactory))
 * prior to using this factory.
 * 
 * @author <a href="mailto:flavia.rainone@jboss.org">Flavia Rainone</a>
 *
 * @version $Revision: 94795 $
 * @see ScopedClassPoolRepository#registerClassLoader(ClassLoader)
 */
public class RepositoryClassPoolFactory implements ClassPoolFactory
{
   private ScopedClassPoolRepository classPoolRepository;
   
   public RepositoryClassPoolFactory(ScopedClassPoolRepository classPoolRepository)
   {
      this.classPoolRepository = classPoolRepository;
   }

   public ClassPool getPoolForLoader(ClassLoader cl)
   {
      return classPoolRepository.registerClassLoader(cl);
   }
}